/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public class DoubleSkullBlockTile
extends EnhancedSkullBlockTile {
    private int rotationUp;
    @Nullable
    private GameProfile ownerUp;
    private SkullBlock.Types typeUp = SkullBlock.Types.SKELETON;
    private int waxColorInd = -1;
    private ResourceLocation waxTexture = null;

    public DoubleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModRegistry.SKULL_PILE_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.waxColorInd != -1) {
            tag.m_128405_("WaxColor", this.waxColorInd);
        }
        tag.m_128405_("RotationUp", this.rotationUp);
        tag.m_128405_("TypeUp", this.typeUp.ordinal());
        if (this.ownerUp != null) {
            CompoundTag compoundtag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compoundtag, (GameProfile)this.ownerUp);
            tag.m_128365_("SkullOwnerUp", (Tag)compoundtag);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        String s;
        super.m_142466_(tag);
        if (tag.m_128441_("WaxColor")) {
            this.waxColorInd = tag.m_128451_("WaxColor");
            DyeColor d = this.waxColorInd == 17 ? null : DyeColor.m_41053_((int)this.waxColorInd);
            this.waxTexture = Textures.SKULL_CANDLES_TEXTURES.get(d);
        } else {
            this.waxTexture = null;
        }
        this.rotationUp = tag.m_128451_("RotationUp");
        this.typeUp = SkullBlock.Types.values()[tag.m_128451_("TypeUp")];
        if (tag.m_128425_("SkullOwnerUp", 10)) {
            this.setOwnerUp(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("SkullOwnerUp")));
        } else if (tag.m_128425_("ExtraTypeUp", 8) && !StringUtil.m_14408_((String)(s = tag.m_128461_("ExtraTypeUp")))) {
            this.setOwnerUp(new GameProfile((UUID)null, s));
        }
    }

    @Nullable
    public GameProfile getOwnerProfileUp() {
        return this.ownerUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwnerUp(@Nullable GameProfile ownerUp) {
        DoubleSkullBlockTile doubleSkullBlockTile = this;
        synchronized (doubleSkullBlockTile) {
            this.ownerUp = ownerUp;
        }
        SkullBlockEntity.m_155738_((GameProfile)this.ownerUp, gameProfile -> {
            this.ownerUp = gameProfile;
            this.m_6596_();
        });
    }

    public SkullBlock.Type getSkullTypeUp() {
        return this.typeUp;
    }

    public void setSkullTypeUp(SkullBlock.Types type) {
        this.typeUp = type;
    }

    public void setRotationUp(float yaw) {
        this.rotationUp = Mth.m_14107_((double)((double)(yaw * 16.0f / 360.0f) + 0.5)) & 0xF;
    }

    public void rotateUp(Rotation rotation) {
        this.rotationUp = rotation.m_55949_(this.rotationUp, 16);
    }

    public void rotateUpStep(int step) {
        this.rotationUp = (this.rotationUp - step + 16) % 16;
    }

    public int getUpRotation() {
        return this.rotationUp;
    }

    public ItemStack getSkullItemUp() {
        return DoubleSkullBlockTile.getSkullItem((SkullBlock.Type)this.typeUp, this.ownerUp);
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, SkullBlock skullBlock, ItemStack skullStack, Player player) {
        BlockItem bi;
        Block block2;
        super.initialize(oldTile, skullBlock, skullStack, player);
        this.setRotationUp(player.m_146908_());
        Item item2 = skullStack.m_41720_();
        if (item2 instanceof BlockItem && (block2 = (bi = (BlockItem)item2).m_40614_()) instanceof SkullBlock) {
            SkullBlock up = (SkullBlock)block2;
            this.setSkullTypeUp((SkullBlock.Types)up.m_48754_());
            GameProfile gameprofile = null;
            if (skullStack.m_41782_()) {
                CompoundTag compoundtag = skullStack.m_41783_();
                if (compoundtag.m_128425_("SkullOwner", 10)) {
                    gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
                } else if (compoundtag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("SkullOwner"))) {
                    gameprofile = new GameProfile(null, compoundtag.m_128461_("SkullOwner"));
                }
            }
            this.setOwnerUp(gameprofile);
        }
    }

    public void updateWax(BlockState above) {
        int index = -1;
        DyeColor c = null;
        Block block2 = above.m_60734_();
        if (block2 instanceof CandleBlock) {
            CandleBlock block3 = (CandleBlock)block2;
            c = CandleSkullBlockTile.colorFromCandle((Block)block3);
            index = c == null ? 17 : c.m_41060_();
        }
        if (this.waxColorInd != index) {
            this.waxColorInd = index;
            if (this.f_58857_ instanceof ServerLevel) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            } else {
                this.waxTexture = this.waxColorInd == -1 ? null : Textures.SKULL_CANDLES_TEXTURES.get(c);
            }
        }
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }
}

