/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CandleSkullBlockTile
extends EnhancedSkullBlockTile {
    private BlockState candle = Blocks.f_50016_.m_49966_();
    private DyeColor color = null;

    public CandleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModRegistry.SKULL_CANDLE_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Candle", (Tag)NbtUtils.m_129202_((BlockState)this.candle));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Candle", 10)) {
            this.candle = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("Candle"));
            this.color = CandleSkullBlockTile.colorFromCandle(this.candle.m_60734_());
        }
    }

    @Nullable
    public DyeColor getCandleColor() {
        return this.color;
    }

    public BlockState getCandle() {
        return this.candle;
    }

    public void setCandle(BlockState candle) {
        this.candle = candle;
    }

    public boolean tryAddingCandle(Block candle) {
        if (this.candle.m_60795_() || candle == this.candle.m_60734_() && (Integer)this.candle.m_61143_((Property)CandleBlock.f_152790_) != 4) {
            if (this.candle.m_60795_()) {
                this.candle = candle.m_49966_();
                this.color = CandleSkullBlockTile.colorFromCandle(this.candle.m_60734_());
            } else {
                this.candle.m_61122_((Property)CandleBlock.f_152790_);
            }
            if (!this.f_58857_.f_46443_) {
                BlockState state = this.m_58900_();
                BlockState newState = BlockUtils.replaceProperty(this.candle, state, CandleBlock.f_152790_);
                this.f_58857_.m_46597_(this.f_58858_, newState);
                this.m_6596_();
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, SkullBlock skullBlock, ItemStack stack, Player player) {
        super.initialize(oldTile, skullBlock, stack, player);
        Item item2 = stack.m_41720_();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            this.tryAddingCandle(blockItem.m_40614_());
        }
    }

    @Nullable
    public static DyeColor colorFromCandle(Block b) {
        if (b instanceof CandleBlock) {
            String n = b.getRegistryName().m_135815_().replace("_candle", "");
            return DyeColor.m_41057_((String)n, null);
        }
        return null;
    }
}

