/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MagmaCreamBlock
extends HalfTransparentBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public MagmaCreamBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity2, float height) {
        if (entity2.m_20162_()) {
            super.m_142072_(world, state, pos, entity2, height);
        } else {
            entity2.m_142535_(height, 0.0f, DamageSource.f_19315_);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (CompatHandler.quark) {
            return;
        }
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !flagIn.m_7050_()) {
            return;
        }
        tooltip.add((Component)new TranslatableComponent("message.supplementaries.magma_cream_block").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean isSlimeBlock(BlockState state) {
        return true;
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        return true;
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        double d0;
        if (!entityIn.m_5825_() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.m_6469_(DamageSource.f_19309_, 1.0f);
        }
        if ((d0 = Math.abs(entityIn.m_20184_().f_82480_)) < 0.1 && !entityIn.m_20161_()) {
            double d1 = 0.4 + d0 * 0.2;
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(d1, 1.0, d1));
        }
        super.m_141947_(worldIn, pos, state, entityIn);
    }

    public boolean canStickToBlock(Level world, BlockPos pistonPos, BlockPos fromPos, BlockPos toPos, BlockState fromState, BlockState toState, Direction moveDir) {
        if (fromState.m_60734_() == this) {
            Direction stickDir = (Direction)fromState.m_61143_((Property)FACING);
            if (fromPos.m_142300_(stickDir).equals((Object)toPos)) {
                return true;
            }
            if (fromPos.m_142300_(stickDir.m_122424_()).equals((Object)toPos)) {
                return false;
            }
            if (toState.m_60734_() == this) {
                Direction stickDir2 = (Direction)toState.m_61143_((Property)FACING);
                return stickDir2 == stickDir || toPos.m_142300_(stickDir2).equals((Object)fromPos) && stickDir != stickDir;
            }
            return toState.m_60734_().isStickyBlock(toState);
        }
        return false;
    }
}

