/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.util.ILightable;
import net.mehvahdjukaar.supplementaries.common.utils.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public abstract class LightUpBlock
extends Block
implements ILightable {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public LightUpBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isLit(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public BlockState toggleLitState(BlockState state, boolean lit) {
        return (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return this.f_60442_.m_76336_();
    }

    public void onChange(BlockState state, LevelAccessor world, BlockPos pos) {
    }

    @Override
    public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSound sound) {
        if (!this.isLit(state)) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, this.toggleLitState(state, true), 11);
                sound.play(world, pos);
            }
            world.m_142346_(player, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean extinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        if (this.isLit(state)) {
            if (!world.m_5776_()) {
                world.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
                world.m_7731_(pos, this.toggleLitState(state, false), 11);
            } else {
                Random random = world.m_5822_();
                for (int i = 0; i < 10; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.m_123342_() + 0.35f + random.nextFloat() * 0.5f), (double)((float)pos.m_123343_() + 0.25f + random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
            }
            world.m_142346_(player, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!this.isLit(state) && player.m_150110_().f_35938_) {
            ItemStack stack = player.m_21120_(handIn);
            Item item2 = stack.m_41720_();
            if (item2 instanceof FlintAndSteelItem || stack.m_150922_(ModTags.FIRE_SOURCES)) {
                if (this.lightUp((Entity)player, state, pos, (LevelAccessor)worldIn, ILightable.FireSound.FLINT_AND_STEEL)) {
                    this.onChange(state, (LevelAccessor)worldIn, pos);
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
            } else if (item2 instanceof FireChargeItem) {
                if (this.lightUp((Entity)player, state, pos, (LevelAccessor)worldIn, ILightable.FireSound.FIRE_CHANGE)) {
                    this.onChange(state, (LevelAccessor)worldIn, pos);
                    stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
            } else if (item2 instanceof PotionItem && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_ && this.extinguish((Entity)player, state, pos, (LevelAccessor)worldIn)) {
                this.onChange(state, (LevelAccessor)worldIn, pos);
                Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)Items.f_42590_));
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        ThrownPotion potion;
        BlockPos pos = pHit.m_82425_();
        if (projectile.m_6060_()) {
            Entity entity2 = projectile.m_37282_();
            if ((entity2 == null || entity2 instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity2)) && this.lightUp((Entity)projectile, state, pos, (LevelAccessor)level, ILightable.FireSound.FLAMING_ARROW)) {
                this.onChange(state, (LevelAccessor)level, pos);
            }
        } else if (projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)(potion = (ThrownPotion)projectile).m_7846_()) == Potions.f_43599_) {
            boolean flag;
            Entity entity3 = projectile.m_37282_();
            boolean bl = flag = entity3 == null || entity3 instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity3);
            if (flag && this.extinguish((Entity)projectile, state, pos, (LevelAccessor)level)) {
                this.onChange(state, (LevelAccessor)level, pos);
            }
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof Projectile) {
            ThrownPotion pot;
            Projectile projectile = (Projectile)entityIn;
            if (projectile.m_6060_()) {
                Entity entity2 = projectile.m_37282_();
                if ((entity2 == null || entity2 instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entity2)) && this.lightUp((Entity)projectile, state, pos, (LevelAccessor)worldIn, ILightable.FireSound.FLAMING_ARROW)) {
                    this.onChange(state, (LevelAccessor)worldIn, pos);
                }
            } else if (projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)(pot = (ThrownPotion)projectile).m_7846_()) == Potions.f_43599_) {
                boolean flag;
                Entity entity3 = projectile.m_37282_();
                boolean bl = flag = entity3 == null || entity3 instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entity3);
                if (flag && this.extinguish((Entity)projectile, state, pos, (LevelAccessor)worldIn)) {
                    this.onChange(state, (LevelAccessor)worldIn, pos);
                }
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState state = this.m_49966_();
        return this.toggleLitState(state, !flag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }
}

