/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SwayingBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedLanternBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnhancedLanternBlock
extends SwayingBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)2.0, (double)0.0, (double)11.0, (double)15.99, (double)10.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)2.0, (double)6.0, (double)11.0, (double)15.99, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)6.0, (double)2.0, (double)5.0, (double)16.0, (double)15.99, (double)11.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)2.0, (double)5.0, (double)10.0, (double)15.99, (double)11.0);

    public EnhancedLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EXTENSION, (Comparable)Integer.valueOf(0)));
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !flagIn.m_7050_()) {
            return;
        }
        tooltip.add((Component)new TranslatableComponent("message.supplementaries.wall_lantern").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_() == Direction.UP || context.m_43719_() == Direction.DOWN) {
            return null;
        }
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        BlockPos relative = blockpos.m_142300_(context.m_43719_().m_122424_());
        BlockState facingState = world.m_8055_(relative);
        boolean flag = world.m_6425_(blockpos).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)EnhancedLanternBlock.getConnectedState(this.m_49966_(), facingState, (LevelAccessor)world, relative).m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void placeOn(BlockState lantern, BlockPos onPos, Direction face, Level world) {
        BlockState state = (BlockState)EnhancedLanternBlock.getConnectedState(this.m_49966_(), world.m_8055_(onPos), (LevelAccessor)world, onPos).m_61124_((Property)FACING, (Comparable)face);
        BlockPos newPos = onPos.m_142300_(face);
        world.m_7731_(newPos, state, 3);
        BlockEntity blockEntity = world.m_7702_(newPos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            tile.setHeldBlock(lantern);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, direction) || CommonUtil.getPostSize(blockstate, blockpos, worldIn) > 0;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new EnhancedLanternBlockTile(pPos, pState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }
}

