/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.api.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.DoubleSkullBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoubleSkullBlock
extends SkullBlock
implements IRotatable {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public DoubleSkullBlock(BlockBehaviour.Properties properties) {
        super((SkullBlock.Type)SkullBlock.Types.SKELETON, properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return super.rotate(state, world, pos, rotation);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new DoubleSkullBlockTile(pPos, pState);
    }

    public List<ItemStack> m_7381_(BlockState pState, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof DoubleSkullBlockTile) {
            DoubleSkullBlockTile tile = (DoubleSkullBlockTile)((Object)object);
            return List.of(tile.getSkullItemUp(), tile.getSkullItem());
        }
        return super.m_7381_(pState, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult hitResult, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DoubleSkullBlockTile) {
            DoubleSkullBlockTile tile = (DoubleSkullBlockTile)blockEntity;
            double y = hitResult.m_82450_().f_82480_;
            boolean up = y % (double)((int)y) > 0.5;
            return up ? tile.getSkullItemUp() : tile.getSkullItem();
        }
        return super.getCloneItemStack(state, hitResult, world, pos, player);
    }

    @Override
    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.of(this.rotate(state, world, pos, rotation));
    }

    @Override
    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DoubleSkullBlockTile) {
            boolean simple;
            DoubleSkullBlockTile tile = (DoubleSkullBlockTile)blockEntity;
            boolean bl = simple = hit == null;
            if (simple) {
                tile.rotateUp(rot);
                IRotatable.super.rotateOverAxis(state, world, pos, rot, axis, null);
            } else {
                int inc;
                boolean up = hit.f_82480_ % (double)((int)hit.f_82480_) > 0.5;
                int n = inc = rot == Rotation.CLOCKWISE_90 ? -1 : 1;
                if (up) {
                    tile.rotateUpStep(inc);
                } else if (world instanceof ServerLevel) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_56314_, (Comparable)Integer.valueOf(((Integer)state.m_61143_((Property)f_56314_) - inc + 16) % 16)), 11);
                }
            }
            tile.m_6596_();
            if (world instanceof Level) {
                Level level = (Level)world;
                level.m_7260_(pos, state, state, 3);
            }
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    public BlockState m_7417_(BlockState pState, Direction dir, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockEntity blockEntity;
        if (dir == Direction.UP && (blockEntity = pLevel.m_7702_(pCurrentPos)) instanceof DoubleSkullBlockTile) {
            DoubleSkullBlockTile tile = (DoubleSkullBlockTile)blockEntity;
            tile.updateWax(pNeighborState);
        }
        return super.m_7417_(pState, dir, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }
}

