/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.common.block.util.IBellConnections;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraftforge.client.model.data.ModelProperty;

public class BlockProperties {
    public static final BooleanProperty EXTENDING = BooleanProperty.m_61465_((String)"extending");
    public static final IntegerProperty HOUR = IntegerProperty.m_61631_((String)"hour", (int)0, (int)23);
    public static final BooleanProperty HAS_WATER = BooleanProperty.m_61465_((String)"has_water");
    public static final BooleanProperty HAS_JAR = BooleanProperty.m_61465_((String)"has_jar");
    public static final IntegerProperty LIGHT_LEVEL_0_15 = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)15);
    public static final IntegerProperty LIGHT_LEVEL_0_7 = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)7);
    public static final BooleanProperty HAS_ITEM = BooleanProperty.m_61465_((String)"has_item");
    public static final IntegerProperty EXTENSION = IntegerProperty.m_61631_((String)"extension", (int)0, (int)2);
    public static final BooleanProperty KNOT = BooleanProperty.m_61465_((String)"knot");
    public static final BooleanProperty TIPPED = BooleanProperty.m_61465_((String)"tipped");
    public static final IntegerProperty PANCAKES_1_8 = IntegerProperty.m_61631_((String)"pancakes", (int)1, (int)8);
    public static final EnumProperty<Topping> TOPPING = EnumProperty.m_61587_((String)"topping", Topping.class);
    public static final EnumProperty<Winding> WINDING = EnumProperty.m_61587_((String)"winding", Winding.class);
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    public static final BooleanProperty AXIS_Y = BooleanProperty.m_61465_((String)"axis_y");
    public static final BooleanProperty AXIS_X = BooleanProperty.m_61465_((String)"axis_x");
    public static final BooleanProperty AXIS_Z = BooleanProperty.m_61465_((String)"axis_z");
    public static final BooleanProperty FLOOR = BooleanProperty.m_61465_((String)"floor");
    public static final BooleanProperty LAVALOGGED = BooleanProperty.m_61465_((String)"lavalogged");
    public static final EnumProperty<RakeDirection> RAKE_DIRECTION = EnumProperty.m_61587_((String)"shape", RakeDirection.class);
    public static final BooleanProperty HAS_BLOCK = BooleanProperty.m_61465_((String)"has_block");
    public static final BooleanProperty ROTATING = BooleanProperty.m_61465_((String)"rotating");
    public static final EnumProperty<PostType> POST_TYPE = EnumProperty.m_61587_((String)"type", PostType.class);
    public static final EnumProperty<BellAttachment> BELL_ATTACHMENT = EnumProperty.m_61587_((String)"attachment", BellAttachment.class);
    public static final EnumProperty<IBellConnections.BellConnection> BELL_CONNECTION = EnumProperty.m_61587_((String)"connection", IBellConnections.BellConnection.class);
    public static final IntegerProperty HONEY_LEVEL_POT = IntegerProperty.m_61631_((String)"honey_level", (int)0, (int)4);
    public static final IntegerProperty BURNING = IntegerProperty.m_61631_((String)"burning", (int)0, (int)8);
    public static final IntegerProperty BOOKS = IntegerProperty.m_61631_((String)"books", (int)1, (int)4);
    public static final BooleanProperty WRITTEN = BooleanProperty.m_61465_((String)"written");
    public static final BooleanProperty ANTIQUE = BooleanProperty.m_61465_((String)"ye_olde");
    public static final BooleanProperty TREASURE = BooleanProperty.m_61465_((String)"treasure");
    public static final BooleanProperty PACKED = BooleanProperty.m_61465_((String)"packed");
    public static final IntegerProperty WIND_STRENGTH = IntegerProperty.m_61631_((String)"wind_strength", (int)0, (int)3);
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Boolean> FANCY = new ModelProperty();
    public static final ModelProperty<Boolean> FRAMED = new ModelProperty();
    public static final EnumProperty<Rune> RUNE = EnumProperty.m_61587_((String)"rune", Rune.class);

    public static enum Topping implements StringRepresentable
    {
        NONE("none"),
        HONEY("honey"),
        SYRUP("syrup"),
        CHOCOLATE("chocolate");

        private final String name;

        private Topping(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Topping fromFluid(SoftFluid s) {
            if (s == SoftFluidRegistry.HONEY) {
                return HONEY;
            }
            String name = s.getRegistryName().m_135815_();
            if (name.equals("chocolate")) {
                return CHOCOLATE;
            }
            if (name.equals("syrup") || name.equals("maple_syrup")) {
                return SYRUP;
            }
            return NONE;
        }
    }

    public static enum Winding implements StringRepresentable
    {
        NONE("none"),
        CHAIN("chain"),
        ROPE("rope");

        private final String name;

        private Winding(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum RakeDirection implements StringRepresentable
    {
        NORTH_SOUTH("north_south", Direction.NORTH, Direction.SOUTH),
        EAST_WEST("east_west", Direction.EAST, Direction.WEST),
        SOUTH_EAST("south_east", Direction.SOUTH, Direction.EAST),
        SOUTH_WEST("south_west", Direction.SOUTH, Direction.WEST),
        NORTH_WEST("north_west", Direction.NORTH, Direction.WEST),
        NORTH_EAST("north_east", Direction.NORTH, Direction.EAST);

        private final List<Direction> directions;
        private final String name;

        private RakeDirection(String name, Direction dir1, Direction dir2) {
            this.name = name;
            this.directions = Arrays.asList(dir1, dir2);
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public List<Direction> getDirections() {
            return this.directions;
        }

        public static RakeDirection fromDirections(List<Direction> directions) {
            for (RakeDirection shape : RakeDirection.values()) {
                if (!shape.getDirections().containsAll(directions)) continue;
                return shape;
            }
            return directions.get(0).m_122434_() == Direction.Axis.Z ? NORTH_SOUTH : EAST_WEST;
        }
    }

    public static enum PostType implements StringRepresentable
    {
        POST("post", 4),
        PALISADE("palisade", 6),
        WALL("wall", 8),
        BEAM("beam", 10);

        private final String name;
        private final int width;

        private PostType(String name, int width) {
            this.name = name;
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum BellAttachment implements StringRepresentable
    {
        CEILING("ceiling"),
        SINGLE_WALL("single_block"),
        DOUBLE_WALL("double_block");

        private final String name;

        private BellAttachment(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Rune implements StringRepresentable
    {
        A("a"),
        B("b"),
        C("c"),
        D("d"),
        E("e"),
        F("f"),
        G("g"),
        H("h"),
        I("i"),
        J("j"),
        K("k"),
        L("l"),
        M("m"),
        N("n"),
        O("o"),
        P("p"),
        Q("q"),
        R("r"),
        S("s"),
        T("t"),
        U("u"),
        V("v"),
        W("w"),
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private Rune(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Attachment implements StringRepresentable
    {
        BLOCK("block"),
        BEAM("beam"),
        WALL("wall"),
        PALISADE("palisade"),
        POST("post");

        private final String name;

        private Attachment(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }
}

