/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractSkullBlockTileRenderer<T extends EnhancedSkullBlockTile>
implements BlockEntityRenderer<T> {
    protected final Map<SkullBlock.Type, SkullModelBase> modelByType;
    protected final BlockRenderDispatcher blockRenderer;
    protected final SkullModelBase overlay;

    public AbstractSkullBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.modelByType = SkullBlockRenderer.m_173661_((EntityModelSet)context.m_173585_());
        this.blockRenderer = Minecraft.m_91087_().m_91289_();
        this.overlay = new SkullModel(context.m_173582_(ClientRegistry.SKULL_CANDLE_OVERLAY));
    }

    public void render(T tile, float pPartialTicks, PoseStack poseStack, MultiBufferSource buffer, int pCombinedLight, int pCombinedOverlay) {
        BlockState blockstate = tile.m_58900_();
        float yaw = 22.5f * (float)((Integer)blockstate.m_61143_((Property)SkullBlock.f_56314_)).intValue();
        this.renderSkull(tile, poseStack, buffer, pCombinedLight, yaw);
    }

    public void renderSkull(T tile, PoseStack poseStack, MultiBufferSource buffer, int pCombinedLight, float yaw) {
        SkullBlock.Types type = ((EnhancedSkullBlockTile)((Object)tile)).getSkullType();
        SkullModelBase modelBase = this.modelByType.get(type);
        RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)((EnhancedSkullBlockTile)((Object)tile)).getOwnerProfile());
        SkullBlockRenderer.m_173663_(null, (float)yaw, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)pCombinedLight, (SkullModelBase)modelBase, (RenderType)renderType);
    }

    public void renderOverlay(PoseStack poseStack, MultiBufferSource buffer, int pCombinedLight, ResourceLocation texture, float yaw) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.25, 0.5);
        float s = 1.077f;
        poseStack.m_85841_(-s, -s, s);
        poseStack.m_85837_(0.0, 0.25, 0.0);
        RenderType overlayTexture = RenderType.m_110464_((ResourceLocation)texture);
        VertexConsumer vertexconsumer = buffer.m_6299_(overlayTexture);
        this.overlay.m_142698_(0.0f, yaw, 0.0f);
        this.overlay.m_7695_(poseStack, vertexconsumer, pCombinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

