/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class BlackboardTextureManager {
    public static final ResourceLocation BLACKBOARD_ATLAS = new ResourceLocation("supplementaries", "textures/atlas/blackboards.png");
    public static BlackboardTextureManager INSTANCE = null;
    private final TextureManager textureManager;
    private long lastID = 0L;
    private final LoadingCache<BlackboardKey, TextureInstance> blackboardTextures = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<BlackboardKey, TextureInstance>(){

        public TextureInstance load(BlackboardKey key) {
            return null;
        }
    });

    public long bindNextID() {
        return ++this.lastID;
    }

    public static void init(TextureManager textureManager) {
        INSTANCE = new BlackboardTextureManager(textureManager);
    }

    public BlackboardTextureManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public RenderType getRenderType(BlackboardBlockTile tile) {
        return this.getTextureInstance((BlackboardBlockTile)tile).renderType;
    }

    public RenderType getRenderType(long[] packed) {
        return this.getTextureInstance((long[])packed).renderType;
    }

    public ResourceLocation getResourceLocation(long[] packed) {
        return this.getTextureInstance((long[])packed).resourceLocation;
    }

    public ResourceLocation getResourceLocation(BlackboardBlockTile tile) {
        return this.getTextureInstance((BlackboardBlockTile)tile).resourceLocation;
    }

    public ResourceLocation getResourceLocation(BlackboardKey key) {
        return this.getTextureInstance((BlackboardKey)key).resourceLocation;
    }

    public RenderType getRenderType(BlackboardKey key) {
        return this.getTextureInstance((BlackboardKey)key).renderType;
    }

    public TextureInstance getTextureInstance(BlackboardKey key) {
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(BlackboardBlockTile.unpackPixels(key.values), this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public TextureInstance getTextureInstance(long[] packed) {
        BlackboardKey key = new BlackboardKey(packed);
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(BlackboardBlockTile.unpackPixels(packed), this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    private TextureInstance getTextureInstance(BlackboardBlockTile tile) {
        BlackboardKey key = this.getOrCreateTextureKey(tile);
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(tile.pixels, this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    private BlackboardKey getOrCreateTextureKey(BlackboardBlockTile tile) {
        if (tile.textureKey == null) {
            tile.textureKey = new BlackboardKey(tile.pixels);
        }
        return tile.textureKey;
    }

    public BlackboardKey getUpdatedKey(BlackboardBlockTile tile) {
        BlackboardKey key = new BlackboardKey(tile.pixels);
        if (this.blackboardTextures.getIfPresent((Object)key) == null) {
            this.blackboardTextures.put((Object)key, (Object)new TextureInstance(tile.pixels, this.bindNextID()));
        }
        return key;
    }

    private static int getColoredPixel(byte i, int x, int y) {
        int offset = i > 0 ? 16 : 0;
        int tint = BlackboardBlock.colorFromByte(i);
        TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
        TextureAtlasSprite sprite = textureMap.m_118316_(Textures.BLACKBOARD_TEXTURE);
        return BlackboardTextureManager.getTintedColor(sprite, x, y, offset, tint);
    }

    private static int getTintedColor(TextureAtlasSprite sprite, int x, int y, int offset, int tint) {
        if (sprite == null || sprite.m_118415_() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int pixel = sprite.getPixelRGBA(0, Math.min(sprite.m_118405_() - 1, x + offset), Math.min(sprite.m_118408_() - 1, y));
        int totalB = pixel >> 16 & 0xFF;
        int totalG = pixel >> 8 & 0xFF;
        int totalR = pixel & 0xFF;
        return NativeImage.m_84992_((int)255, (int)(totalB * tintB / 255), (int)(totalG * tintG / 255), (int)(totalR * tintR / 255));
    }

    private class TextureInstance
    implements AutoCloseable {
        private static final int WIDTH = 16;
        private final DynamicTexture texture = new DynamicTexture(16, 16, false);
        private final RenderType renderType;
        private final ResourceLocation resourceLocation;

        private TextureInstance(byte[][] pixels, long id) {
            this.updateTexture(pixels);
            this.resourceLocation = BlackboardTextureManager.this.textureManager.m_118490_("blackboard/" + Long.toHexString(id), this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.resourceLocation);
        }

        private void updateTexture(byte[][] pixels) {
            for (int y = 0; y < pixels.length && y < 16; ++y) {
                for (int x = 0; x < pixels[y].length && x < 16; ++x) {
                    this.texture.m_117991_().m_84988_(x, y, BlackboardTextureManager.getColoredPixel(pixels[x][y], x, y));
                }
            }
            this.texture.m_117985_();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }

    public static class BlackboardKey {
        private final long[] values;

        public BlackboardKey(long[] packed) {
            this.values = packed;
        }

        public BlackboardKey(byte[][] pixels) {
            this.values = BlackboardBlockTile.packPixels(pixels);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            BlackboardKey key = (BlackboardKey)another;
            return Arrays.equals(this.values, key.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

