/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.mehvahdjukaar.supplementaries.client.gui.widgets.MultiLineEditBoxWidget;
import net.mehvahdjukaar.supplementaries.client.gui.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.PresentContainerMenu;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetPresentPacket;
import net.mehvahdjukaar.supplementaries.common.utils.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PresentBlockGui
extends AbstractContainerScreen<PresentContainerMenu>
implements ContainerListener {
    private static final int DESCRIPTION_BOX_X = 53;
    private static final int DESCRIPTION_BOX_Y = 33;
    private static final int DESCRIPTION_BOX_H = 36;
    private static final int DESCRIPTION_BOX_W = 105;
    private static final int SUGGESTION_BOX_Y = 19;
    private static final int SUGGESTION_BOX_W = 99;
    private static final int SUGGESTION_BOX_H = 12;
    private final PresentBlockTile tile;
    private PackButton packButton;
    private PlayerSuggestionBoxWidget recipient;
    private MultiLineEditBoxWidget descriptionBox;
    private boolean packed;
    private boolean needsInitialization = true;
    public static MenuScreens.ScreenConstructor<PresentContainerMenu, PresentBlockGui> GUI_FACTORY = (container, inventory, title) -> {
        BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(container.getPos());
        if (te instanceof PresentBlockTile) {
            PresentBlockTile presentBlockTile = (PresentBlockTile)te;
            return new PresentBlockGui((PresentContainerMenu)container, inventory, title, presentBlockTile);
        }
        return null;
    };

    public PresentBlockGui(PresentContainerMenu container, Inventory inventory, Component text, PresentBlockTile tile) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.tile = tile;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.packButton = (PackButton)this.m_142416_((GuiEventListener)new PackButton(i + 14, j + 45));
        this.recipient = (PlayerSuggestionBoxWidget)this.m_142416_((GuiEventListener)new PlayerSuggestionBoxWidget(this.f_96541_, i + 53, j + 19, 99, 12));
        this.recipient.setOutOfBoundResponder(up -> {
            if (!up.booleanValue()) {
                this.m_7522_((GuiEventListener)this.descriptionBox);
                this.recipient.m_93692_(false);
                this.descriptionBox.m_93692_(true);
            }
        });
        this.descriptionBox = (MultiLineEditBoxWidget)this.m_142416_((GuiEventListener)new MultiLineEditBoxWidget(this.f_96541_, i + 53, j + 33, 105, 36));
        this.descriptionBox.setOutOfBoundResponder(up -> {
            if (up.booleanValue()) {
                this.m_7522_((GuiEventListener)this.recipient);
                this.recipient.m_93692_(true);
                this.descriptionBox.m_93692_(false);
            }
        });
        this.m_7522_((GuiEventListener)this.recipient);
        this.recipient.setText(this.tile.getRecipient());
        this.descriptionBox.setText(this.tile.getDescription());
        this.packed = this.tile.isPacked();
        this.updateState();
        ((PresentContainerMenu)this.f_97732_).m_38893_(this);
    }

    public void onAddPlayer(PlayerInfo info) {
        this.recipient.addPlayer(info);
    }

    public void onRemovePlayer(UUID uuid) {
        this.recipient.removePlayer(uuid);
    }

    private void pack() {
        this.updateStateAndTryToPack(true);
    }

    private void updateState() {
        this.updateStateAndTryToPack(false);
    }

    private void updateStateAndTryToPack(boolean tryToPack) {
        boolean hasItem = this.needsInitialization ? this.packed : ((PresentContainerMenu)this.f_97732_).m_38853_(0).m_6657_();
        boolean hasChanged = false;
        if (this.packed && !hasItem) {
            this.packed = false;
            hasChanged = true;
        } else if (tryToPack && !this.packed && hasItem) {
            this.packed = true;
            hasChanged = true;
        }
        if (hasChanged) {
            String sender = Minecraft.m_91087_().f_91074_.m_7755_().getString();
            String recipient = this.recipient.getText();
            String description = this.descriptionBox.getText();
            NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundSetPresentPacket(this.tile.m_58899_(), this.packed, recipient, sender, description));
            this.tile.updateState(this.packed, recipient, sender, description);
            if (this.packed) {
                this.f_96541_.f_91074_.m_108763_();
            }
        }
        this.recipient.setState(hasItem, this.packed);
        this.packButton.setState(hasItem, this.packed);
        this.descriptionBox.setState(hasItem, this.packed);
    }

    public void m_7934_(AbstractContainerMenu container, int slot, ItemStack stack) {
        if (slot == 0) {
            this.updateState();
        }
    }

    public void m_142153_(AbstractContainerMenu container, int p_150525_, int p_150526_) {
        this.m_7934_(container, 0, container.m_38853_(0).m_7993_());
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.PRESENT_BLOCK_GUI_TEXTURE);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, k, l, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.packed) {
            int k = (this.f_96543_ - this.f_97726_) / 2;
            int l = (this.f_96544_ - this.f_97727_) / 2;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.PRESENT_BLOCK_GUI_TEXTURE);
            Slot slot = ((PresentContainerMenu)this.f_97732_).m_38853_(0);
            PresentBlockGui.m_93143_((PoseStack)poseStack, (int)(k + slot.f_40220_), (int)(l + slot.f_40221_), (int)400, (float)12.0f, (float)232.0f, (int)16, (int)16, (int)256, (int)256);
        }
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        super.m_7027_(poseStack, x, y);
        this.packButton.m_7428_(poseStack, x - this.f_97735_, y - this.f_97736_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int key) {
        this.recipient.m_93692_(false);
        this.descriptionBox.m_93692_(false);
        return super.m_6375_(mouseX, mouseY, key);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.recipient.m_6050_(mouseX, mouseY, amount) || this.descriptionBox.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int key, int a, int b) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.recipient.m_7933_(key, a, b) || this.recipient.canConsumeInput() || this.descriptionBox.m_7933_(key, a, b) || this.descriptionBox.canConsumeInput() || super.m_7933_(key, a, b);
    }

    public boolean m_7979_(double dx, double dy, int key, double mouseX, double mouseY) {
        if (key == 0 && this.descriptionBox.m_7979_(dx, dy, key, mouseX, mouseY)) {
            return true;
        }
        return super.m_7979_(dx, dy, key, mouseX, mouseY);
    }

    public void m_181908_() {
        this.needsInitialization = false;
        super.m_181908_();
        this.recipient.tick();
        this.descriptionBox.tick();
    }

    public void m_7861_() {
        super.m_7861_();
        ((PresentContainerMenu)this.f_97732_).m_38943_(this);
        Minecraft.m_91087_().f_91068_.m_90926_(false);
    }

    public class PackButton
    extends AbstractButton {
        private boolean packed;

        protected PackButton(int x, int y) {
            super(x, y, 22, 22, TextComponent.f_131282_);
        }

        public void m_6303_(PoseStack poseStack, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.PRESENT_BLOCK_GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = 198;
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.packed) {
                j += this.f_93618_ * 1;
            } else if (this.f_93622_) {
                j += this.f_93618_ * 3;
            }
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, j, i, this.f_93618_, this.f_93619_);
        }

        public void setState(boolean hasItem, boolean packed) {
            this.packed = packed;
            this.f_93623_ = hasItem;
        }

        public void m_7428_(PoseStack matrixStack, int x, int y) {
            if (this.m_142518_() && this.m_198029_() && !this.packed) {
                PresentBlockGui.this.m_96602_(matrixStack, (Component)new TranslatableComponent("gui.supplementaries.present.pack"), x, y);
            }
        }

        public void m_5691_() {
            PresentBlockGui.this.pack();
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }
}

