/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import org.jetbrains.annotations.NotNull;

public class WallLanternBakedModel
implements IDynamicBakedModel {
    private final BakedModel support;
    private final BlockModelShaper blockModelShaper;

    public WallLanternBakedModel(BakedModel support) {
        this.support = support;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            quads.addAll(this.support.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BlockState mimic;
            boolean fancy = Boolean.TRUE.equals(extraData.getData(BlockProperties.FANCY));
            if (!(fancy || (mimic = (BlockState)extraData.getData(BlockProperties.MIMIC)) == null || mimic.m_60734_() instanceof MimicBlock || mimic.m_60795_() || state == null)) {
                Direction dir = (Direction)state.m_61143_((Property)WallLanternBlock.FACING);
                if (mimic.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    mimic = (BlockState)mimic.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
                } else if (mimic.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    mimic = (BlockState)mimic.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir);
                }
                BakedModel model = this.blockModelShaper.m_110893_(mimic);
                List mimicQuads = model.getQuads(mimic, side, rand, (IModelData)EmptyModelData.INSTANCE);
                TextureAtlasSprite texture = this.m_6160_();
                for (BakedQuad q : mimicQuads) {
                    int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
                    RendererUtil.moveVertices(v, Direction.UP, 0.125f, texture);
                    RendererUtil.moveVertices(v, dir, -0.125f, texture);
                    quads.add(new BakedQuad(v, q.m_111305_(), q.m_111306_(), q.m_173410_(), q.m_111307_()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.support.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        BlockState mimic = (BlockState)data.getData(BlockProperties.MIMIC);
        if (mimic != null && !mimic.m_60795_()) {
            BakedModel model = this.blockModelShaper.m_110893_(mimic);
            try {
                return model.m_6160_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    private void putVertex(BakedQuadBuilder builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        int tw = sprite.m_118405_();
        int th = sprite.m_118408_();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        this.putVertex(builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, 0.0f, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0f, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, tw, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, tw, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }
}

