/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class BlackboardBakedModel
implements IDynamicBakedModel {
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ItemOverrides overrides;
    private final ResourceLocation modelLocation;
    private final BlockModel unbaked;
    private final String toRetextureName;

    public BlackboardBakedModel(BlockModel unbaked, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation, String toRetextureName) {
        this.unbaked = unbaked;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
        this.modelLocation = modelLocation;
        this.toRetextureName = toRetextureName;
    }

    private BakedModel rebake(ResourceLocation replacement) {
        return null;
    }

    public boolean m_7541_() {
        return this.unbaked.m_111476_();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(this.owner.resolveTexture("particle"));
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public static Set<String> getAllRetextured(IModelConfiguration owner, BlockModel model, String originalSet) {
        HashSet retextured = Sets.newHashSet((Object[])new String[]{originalSet});
        model.f_111417_.forEach((name, either) -> either.ifRight(parent -> {
            if (retextured.contains(parent)) {
                retextured.add(name);
            }
        }));
        return ImmutableSet.copyOf((Collection)retextured);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
        BlackboardTextureManager.BlackboardKey key;
        if (data != EmptyModelData.INSTANCE && (key = null) != null) {
            ResourceLocation texture = BlackboardTextureManager.INSTANCE.getResourceLocation(key);
            this.unbaked.f_111417_.replace(this.toRetextureName, Either.right((Object)texture.toString()));
        }
        BakedModel baked = this.unbaked.m_111449_(this.bakery, this.unbaked, this.spriteGetter, this.modelTransform, this.modelLocation, true);
        return baked.getQuads(state, direction, random, data);
    }
}

