/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DyeHelper {
    private static final HashMap<String, Collection<Item>> TAGS = new HashMap();
    private static final HashMap<String, DyeColor> DYES = new HashMap();
    private static final HashSet<String> NON_DYES = new HashSet();

    public static String getDyeName(ItemStack stack) {
        return stack.m_41619_() ? "" : DyeHelper.getDyeName(stack.m_41720_());
    }

    public static String getDyeName(Item item) {
        if (item != null) {
            DyeColor dyeColor = DyeHelper.getDyeColor(item);
            return dyeColor == null ? "" : dyeColor.m_41065_();
        }
        return "";
    }

    public static DyeColor getDyeColor(ItemStack stack) {
        return stack.m_41619_() ? null : DyeHelper.getDyeColor(stack.m_41720_());
    }

    public static DyeColor getDyeColor(Item item) {
        if (item != null) {
            String id = item.getRegistryName().toString();
            if (DYES.containsKey(id)) {
                return DYES.get(id);
            }
            if (!NON_DYES.contains(id)) {
                if (TAGS.isEmpty()) {
                    DyeHelper.generate();
                }
                for (DyeColor dyeColor : DyeColor.values()) {
                    String dyeName = dyeColor.m_41065_();
                    if (!TAGS.get(dyeName).contains(item)) continue;
                    DYES.put(id, dyeColor);
                    return dyeColor;
                }
            }
            NON_DYES.add(id);
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return !stack.m_41619_() && DyeHelper.isDye(stack.m_41720_());
    }

    public static boolean isDye(Item item) {
        if (item != null) {
            String id = item.getRegistryName().toString();
            if (DYES.containsKey(id)) {
                return true;
            }
            if (!NON_DYES.contains(id)) {
                if (TAGS.isEmpty()) {
                    DyeHelper.generate();
                }
                return TAGS.get("all").contains(item);
            }
            NON_DYES.add(id);
        }
        return false;
    }

    private static void generate() {
        TAGS.put("all", ItemTags.m_13194_((String)"forge:dyes").m_6497_());
        for (DyeColor dyeColor : DyeColor.values()) {
            TAGS.put(dyeColor.m_41065_(), ItemTags.m_13194_((String)("forge:dyes/" + dyeColor.m_41065_())).m_6497_());
        }
    }
}

