/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;
import shetiphian.core.client.model.IPartData;
import shetiphian.core.client.model.RetexturedBlockModel;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractModelCacheBuilder {
    private final Logger LOGGER;
    private final Table<String, String, EnumMap<Direction, BakedModel>> CACHE = HashBasedTable.create();
    private final List<String> PART_ERROR = new ArrayList<String>();
    protected ModelBakery BAKERY;
    protected Function<Material, TextureAtlasSprite> SPRITE_GETTER;
    protected ItemModelShaper MESHER;
    private static UnbakedModel MISSING_MODEL;

    public AbstractModelCacheBuilder(Logger logger) {
        this.LOGGER = logger;
    }

    public void preBakeSetup(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.BAKERY = bakery;
        this.SPRITE_GETTER = spriteGetter;
    }

    protected void clearCache() {
        this.CACHE.clear();
    }

    protected BakedModel get(String part, String key, Direction facing, String particle, List<IPartData> models) {
        Map map;
        if (!this.CACHE.contains((Object)part, (Object)key)) {
            this.buildCache(part, key, particle, models);
        }
        if ((map = (Map)this.CACHE.get((Object)part, (Object)key)) == null) {
            map = (Map)this.CACHE.get((Object)part, (Object)"default");
        }
        return map == null ? null : (BakedModel)map.get(facing);
    }

    protected void buildCache(String part, String key, String particle, List<IPartData> models) {
        String partName;
        IPartData modeldata = null;
        for (IPartData data : models) {
            if (!data.getName().equalsIgnoreCase(part)) continue;
            modeldata = data;
            break;
        }
        if (modeldata == null) {
            return;
        }
        UnbakedModel unbaked = null;
        if (this.BAKERY != null) {
            unbaked = this.getModelOrMissing(modeldata.getLocation());
            if (unbaked.equals(this.BAKERY.m_119341_((ResourceLocation)ModelBakery.f_119230_)) && !this.PART_ERROR.contains(partName = part.toLowerCase(Locale.ROOT))) {
                unbaked = this.getModelOrMissing(modeldata.getLocation());
            }
            if (unbaked.equals(this.BAKERY.m_119341_((ResourceLocation)ModelBakery.f_119230_))) {
                unbaked = null;
            }
        }
        if (unbaked == null) {
            partName = part.toLowerCase(Locale.ROOT);
            if (!this.PART_ERROR.contains(partName)) {
                this.LOGGER.error("Unable to retrieve model form the ModelLoaderRegistry, this part may not render correctly: " + part);
                this.PART_ERROR.add(partName);
            }
            return;
        }
        if (!this.CACHE.contains((Object)modeldata.getName(), (Object)"default")) {
            if (unbaked instanceof BlockModel) {
                this.CACHE.put((Object)modeldata.getName(), (Object)"default", this.getMap((UnbakedModel)RetexturedBlockModel.from((BlockModel)unbaked).retexture(this.setTextures(modeldata, modeldata.getDefaultTexture(), particle)), modeldata.getLocation()));
            } else {
                this.CACHE.put((Object)modeldata.getName(), (Object)"default", this.getMap(unbaked, modeldata.getLocation()));
            }
        }
        if (!key.equals("default")) {
            if (unbaked instanceof BlockModel) {
                this.CACHE.put((Object)modeldata.getName(), (Object)key, this.getMap((UnbakedModel)RetexturedBlockModel.from((BlockModel)unbaked).retexture(this.setTextures(modeldata, key, particle)), modeldata.getLocation()));
            } else {
                this.CACHE.put((Object)modeldata.getName(), (Object)key, this.getMap(unbaked, modeldata.getLocation()));
            }
        }
    }

    protected UnbakedModel getModelOrMissing(ResourceLocation location) {
        try {
            return this.BAKERY.m_119341_(location);
        }
        catch (Exception e) {
            if (MISSING_MODEL == null) {
                try {
                    MISSING_MODEL = this.BAKERY.m_119341_((ResourceLocation)ModelBakery.f_119230_);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Missing the missing model, this should never happen");
                }
            }
            return MISSING_MODEL;
        }
    }

    public String getTexture(ItemStack stack) {
        return this.getTextureSprite(stack).m_118413_().toString();
    }

    public TextureAtlasSprite getTextureSprite(ItemStack stack) {
        try {
            if (this.MESHER == null) {
                this.MESHER = Minecraft.m_91087_().m_91291_().m_115103_();
            }
            BakedModel model = this.MESHER.m_109406_(stack);
            return model.m_6160_();
        }
        catch (Exception exception) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
    }

    protected abstract ImmutableMap<String, String> setTextures(IPartData var1, String var2, String var3);

    protected EnumMap<Direction, BakedModel> getMap(UnbakedModel model, ResourceLocation location) {
        EnumMap<Direction, BakedModel> map = new EnumMap<Direction, BakedModel>(Direction.class);
        map.put(Direction.NORTH, model.m_7611_(this.BAKERY, this.SPRITE_GETTER, (ModelState)BlockModelRotation.X0_Y0, location));
        map.put(Direction.EAST, model.m_7611_(this.BAKERY, this.SPRITE_GETTER, (ModelState)BlockModelRotation.X0_Y90, location));
        map.put(Direction.SOUTH, model.m_7611_(this.BAKERY, this.SPRITE_GETTER, (ModelState)BlockModelRotation.X0_Y180, location));
        map.put(Direction.WEST, model.m_7611_(this.BAKERY, this.SPRITE_GETTER, (ModelState)BlockModelRotation.X0_Y270, location));
        return map;
    }
}

