/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFunctions {
    public static GuiPass guiPass = new GuiPass((Component)new TextComponent("PassThroughGUI"));

    private static float[] getPixelScale(int ... imageSize) {
        int width;
        int n = width = imageSize.length >= 1 ? imageSize[0] : 256;
        int height = imageSize.length >= 2 ? imageSize[1] : (imageSize.length == 1 ? width : 256);
        return new float[]{1.0f / (float)width, 1.0f / (float)height};
    }

    public static void enterDrawTextureState() {
        RenderSystem.m_69465_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void enterDrawTextureStateWithBlend() {
        GuiFunctions.enterDrawTextureState();
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
    }

    public static void exitDrawTextureStateWithBlend() {
        RenderSystem.m_69461_();
        GuiFunctions.exitDrawTextureState();
    }

    public static void exitDrawTextureState() {
        RenderSystem.m_69482_();
    }

    public static void drawTexture(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureScaled(matrixStack, posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + (double)sizeU * scale};
        double[] y = new double[]{posY, posY + (double)sizeV * scale};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x[0], (float)y[1], zLevel).m_7421_(u[0], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[1], zLevel).m_7421_(u[1], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[0], zLevel).m_7421_(u[1], v[0]).m_5752_();
        renderer.m_85982_(matrix, (float)x[0], (float)y[0], zLevel).m_7421_(u[0], v[0]).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }

    public static void drawTextureMirrored(PoseStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureMirroredAndScaled(matrixStack, posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureMirroredAndScaled(PoseStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x[0], (float)y[1], zLevel).m_7421_(u[1], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[1], zLevel).m_7421_(u[0], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[0], zLevel).m_7421_(u[0], v[0]).m_5752_();
        renderer.m_85982_(matrix, (float)x[0], (float)y[0], zLevel).m_7421_(u[1], v[0]).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }

    public static void drawTextureInverted(PoseStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureInvertedAndScaled(matrixStack, posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureInvertedAndScaled(PoseStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x[0], (float)y[1], zLevel).m_7421_(u[0], v[0]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[1], zLevel).m_7421_(u[1], v[0]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[0], zLevel).m_7421_(u[1], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[0], (float)y[0], zLevel).m_7421_(u[0], v[1]).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }

    public static void drawHorizontalGradient(PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel, int colorRight, int colorLeft) {
        GuiFunctions.drawGradientRect(matrixStack, left, top, right, bottom, zLevel, colorRight, colorLeft, colorLeft, colorRight);
    }

    public static void drawGradientRect(PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel, int colorTop, int colorBottom) {
        GuiFunctions.drawGradientRect(matrixStack, left, top, right, bottom, zLevel, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel, int color) {
        GuiFunctions.drawGradientRect(matrixStack, left, top, right, bottom, zLevel, color, color, color, color);
    }

    public static void drawGradientRect(PoseStack matrixStack, double left, double top, double right, double bottom, float zLevel, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiFunctions.addColoredVertex(matrix, renderer, right, top, zLevel, colorTopRight);
        GuiFunctions.addColoredVertex(matrix, renderer, left, top, zLevel, colorTopLeft);
        GuiFunctions.addColoredVertex(matrix, renderer, left, bottom, zLevel, colorBottomLeft);
        GuiFunctions.addColoredVertex(matrix, renderer, right, bottom, zLevel, colorBottomRight);
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    private static void addColoredVertex(Matrix4f matrix, BufferBuilder renderer, double x, double y, float zLevel, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        renderer.m_85982_(matrix, (float)x, (float)y, zLevel).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public static void drawTexturedPane(PoseStack matrixStack, double posX, double posY, double sizeX, double sizeY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + sizeX};
        double[] y = new double[]{posY, posY + sizeY};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x[0], (float)y[1], zLevel).m_7421_(u[0], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[1], zLevel).m_7421_(u[1], v[1]).m_5752_();
        renderer.m_85982_(matrix, (float)x[1], (float)y[0], zLevel).m_7421_(u[1], v[0]).m_5752_();
        renderer.m_85982_(matrix, (float)x[0], (float)y[0], zLevel).m_7421_(u[0], v[0]).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }

    public static class GuiPass
    extends Screen {
        protected GuiPass(Component p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void setZLevel(float zLevel) {
            if (this.f_96542_ != null) {
                this.f_96542_.f_115093_ = zLevel;
            }
        }

        public void m_93179_(PoseStack matrixStack, int x1, int y1, int x2, int y2, int color1, int color2) {
            super.m_93179_(matrixStack, x1, y1, x2, y2, color1, color2);
        }
    }
}

