/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item.tool;

import com.blakebr0.cucumber.item.tool.BaseBowItem;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceBowItem
extends BaseBowItem
implements ITinkerable {
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.WEAPON, AugmentType.BOW);
    private final int tinkerableTier;
    private final int slots;
    private final float drawSpeedMulti;

    public EssenceBowItem(Tier tier, int tinkerableTier, int slots, float drawSpeedMulti, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.m_41503_(tier.m_6609_())));
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
        this.drawSpeedMulti = drawSpeedMulti;
    }

    public int m_8105_(ItemStack stack) {
        return (int)((float)super.m_8105_(stack) * this.drawSpeedMulti);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        List<Augment> augments = AugmentUtils.getAugments(context.m_43722_());
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onItemUse(context)) continue;
            success = true;
        }
        if (success) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onRightClick(stack, level, player, hand)) continue;
            success = true;
        }
        if (success) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onRightClickEntity(stack, player, target, hand)) continue;
            success = true;
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onHitEntity(stack, target, attacker)) continue;
            success = true;
        }
        return success;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        super.m_6813_(stack, world, state, pos, entity);
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onBlockDestroyed(stack, world, state, pos, entity)) continue;
            success = true;
        }
        return success;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        List<Augment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (Augment augment : augments) {
            if (!augment.onBlockStartBreak(stack, pos, player)) continue;
            success = true;
        }
        return success;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean isSelected) {
        AugmentUtils.getAugments(stack).forEach(a -> a.onInventoryTick(stack, world, entity, slot, isSelected));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        AugmentUtils.getAugments(stack).forEach(a -> tooltip.add((Component)a.getDisplayName().m_130940_(ChatFormatting.GRAY)));
    }

    @Override
    public int getAugmentSlots() {
        return this.slots;
    }

    @Override
    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    @Override
    public int getTinkerableTier() {
        return this.tinkerableTier;
    }

    public float getDrawSpeedMulti(ItemStack stack) {
        return this.drawSpeedMulti;
    }
}

