/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.condition;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class CropHasMaterialCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("mysticalagriculture", "crop_has_material");
    private final ResourceLocation crop;

    public CropHasMaterialCondition(ResourceLocation crop) {
        this.crop = crop;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test() {
        Crop crop = CropRegistry.getInstance().getCropById(this.crop);
        if (crop == null) {
            return false;
        }
        Ingredient material = crop.getCraftingMaterial();
        return material != null && !material.m_43947_();
    }

    public static class Serializer
    implements IConditionSerializer<CropHasMaterialCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, CropHasMaterialCondition value) {
            json.addProperty("crop", value.crop.toString());
        }

        public CropHasMaterialCondition read(JsonObject json) {
            String crop = GsonHelper.m_13906_((JsonObject)json, (String)"crop");
            return new CropHasMaterialCondition(new ResourceLocation(crop));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

