/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.block.MysticalCropBlock;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.Set;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((tooltip, accessor, config) -> {
            Biome biome;
            Set<ResourceLocation> biomes;
            Block crux;
            Block block = accessor.getBlock();
            Crop crop = ((ICropProvider)block).getCrop();
            tooltip.add((Component)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
            BlockPos pos = accessor.getPosition();
            BlockPos downPos = pos.m_7495_();
            Level level = accessor.getLevel();
            Block belowBlock = level.m_8055_(downPos).m_60734_();
            double secondaryChance = crop.getSecondaryChance(belowBlock);
            if (secondaryChance > 0.0) {
                MutableComponent chanceText = new TextComponent(String.valueOf((int)(secondaryChance * 100.0))).m_130946_("%").m_130940_(crop.getTier().getTextColor());
                tooltip.add((Component)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
            }
            if ((crux = crop.getCruxBlock()) != null) {
                ItemStack stack = new ItemStack((ItemLike)crux);
                tooltip.add((Component)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack.m_41786_()}).build());
            }
            if (!(biomes = crop.getRequiredBiomes()).isEmpty() && !biomes.contains((biome = level.m_46857_(pos)).getRegistryName())) {
                tooltip.add((Component)ModTooltips.INVALID_BIOME.color(ChatFormatting.RED).build());
            }
        }, TooltipPosition.BODY, MysticalCropBlock.class);
        registrar.registerComponentProvider((tooltip, accessor, config) -> {
            Block block = accessor.getBlock();
            Crop crop = ((ICropProvider)block).getCrop();
            BlockPos downPos = accessor.getPosition().m_7495_();
            Block belowBlock = accessor.getLevel().m_8055_(downPos).m_60734_();
            int output = 100;
            if (belowBlock instanceof IEssenceFarmland) {
                IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                int tier = farmland.getTier().getValue();
                output = tier * 50 + 50;
            }
            MutableComponent inferiumOutputText = new TextComponent(String.valueOf(output)).m_130946_("%").m_130940_(crop.getTier().getTextColor());
            tooltip.add((Component)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
        }, TooltipPosition.BODY, InferiumCropBlock.class);
        registrar.registerComponentProvider((tooltip, accessor, config) -> {
            Block block = accessor.getBlock();
            IEssenceFarmland farmland = (IEssenceFarmland)block;
            tooltip.add((Component)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
        }, TooltipPosition.BODY, InfusedFarmlandBlock.class);
    }
}

