/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MysticalCropBlock
extends CropBlock
implements ICropProvider {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final Crop crop;

    public MysticalCropBlock(Crop crop) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_));
        this.crop = crop;
    }

    public boolean m_5491_(Level world, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!this.canGrow((Level)world, pos)) {
            return;
        }
        super.m_7455_(state, world, pos, random);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public String m_7705_() {
        return Localizable.of((String)"block.mysticalagriculture.mystical_crop").args(new Object[]{this.crop.getDisplayName()}).buildString();
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        int age = (Integer)state.m_61143_((Property)f_52244_);
        int crop = 0;
        int seed = 1;
        int fertilizer = 0;
        if (age == this.m_7419_()) {
            crop = 1;
            Vec3 vec = (Vec3)builder.m_78982_(LootContextParams.f_81460_);
            if (vec != null) {
                ServerLevel world = builder.m_78962_();
                BlockPos pos = new BlockPos(vec);
                Block below = world.m_8055_(pos.m_7495_()).m_60734_();
                double chance = this.crop.getSecondaryChance(below);
                if (Math.random() < chance) {
                    crop = 2;
                }
                if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && Math.random() < chance) {
                    seed = 2;
                }
                double fertilizerChance = (Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get();
                if (Math.random() < fertilizerChance) {
                    fertilizer = 1;
                }
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (crop > 0) {
            drops.add(new ItemStack(this.getCropsItem(), crop));
        }
        drops.add(new ItemStack(this.m_6404_(), seed));
        if (fertilizer > 0) {
            drops.add(new ItemStack((ItemLike)ModItems.FERTILIZED_ESSENCE.get()));
        }
        return drops;
    }

    public void m_7719_(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        if (!this.canGrow((Level)world, pos)) {
            return;
        }
        super.m_7719_(world, rand, pos, state);
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        if (world instanceof Level) {
            return this.canGrow((Level)world, pos) && super.m_7370_(world, pos, state, isClient);
        }
        return super.m_7370_(world, pos, state, isClient);
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60734_() instanceof FarmBlock;
    }

    protected ItemLike m_6404_() {
        return this.crop.getSeedsItem();
    }

    @Override
    public Crop getCrop() {
        return this.crop;
    }

    protected ItemLike getCropsItem() {
        return this.crop.getEssenceItem();
    }

    private boolean canGrow(Level world, BlockPos pos) {
        Block block;
        Block crux = this.crop.getCruxBlock();
        if (crux != null && (block = world.m_8055_(pos.m_6625_(2)).m_60734_()) != crux) {
            return false;
        }
        Set<ResourceLocation> biomes = this.crop.getRequiredBiomes();
        if (!biomes.isEmpty()) {
            Biome biome = world.m_46857_(pos);
            return biomes.contains(biome.getRegistryName());
        }
        return true;
    }
}

