/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.EssenceFurnaceTileEntity;
import com.blakebr0.mysticalagriculture.util.FurnaceTier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EssenceFurnaceBlock
extends AbstractFurnaceBlock {
    private final FurnaceTier tier;

    public EssenceFurnaceBlock(FurnaceTier tier) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50094_));
        this.tier = tier;
    }

    protected void m_7137_(Level level, BlockPos pos, Player player) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof EssenceFurnaceTileEntity) {
            EssenceFurnaceTileEntity furnace = (EssenceFurnaceTileEntity)tile;
            player.m_5893_((MenuProvider)furnace);
            player.m_36220_(Stats.f_12966_);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.tier.createTileEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.m_60734_() != newState.m_60734_() && (tile = level.m_7702_(pos)) instanceof EssenceFurnaceTileEntity) {
            EssenceFurnaceTileEntity furnace = (EssenceFurnaceTileEntity)tile;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)furnace);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        double cookingSpeedDifference = 200.0 * this.tier.getCookTimeMultiplier();
        double cookingSpeedValue = Math.ceil((200.0 - cookingSpeedDifference) / cookingSpeedDifference * 100.0) + 100.0;
        MutableComponent cookingSpeed = new TextComponent(String.valueOf((int)cookingSpeedValue)).m_130946_("%");
        double burnTimeDifference = 1600.0 * this.tier.getBurnTimeMultiplier() / cookingSpeedDifference;
        double burnTimeValue = Math.ceil((burnTimeDifference - 8.0) / 8.0 * 100.0) + 100.0;
        MutableComponent fuelEfficiency = new TextComponent(String.valueOf((int)burnTimeValue)).m_130946_("%");
        tooltip.add((Component)ModTooltips.COOKING_SPEED.args(new Object[]{cookingSpeed}).build());
        tooltip.add((Component)ModTooltips.FUEL_EFFICIENCY.args(new Object[]{fuelEfficiency}).build());
    }

    public static class Supremium
    extends EssenceFurnaceBlock {
        public Supremium() {
            super(FurnaceTier.SUPREMIUM);
        }

        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            return this.createTicker(level, type);
        }

        protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type) {
            return level.f_46443_ ? null : Supremium.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTileEntities.SUPREMIUM_FURNACE.get()), EssenceFurnaceTileEntity::tick);
        }
    }

    public static class Imperium
    extends EssenceFurnaceBlock {
        public Imperium() {
            super(FurnaceTier.IMPERIUM);
        }

        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            return this.createTicker(level, type);
        }

        protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type) {
            return level.f_46443_ ? null : Imperium.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTileEntities.IMPERIUM_FURNACE.get()), EssenceFurnaceTileEntity::tick);
        }
    }

    public static class Tertium
    extends EssenceFurnaceBlock {
        public Tertium() {
            super(FurnaceTier.TERTIUM);
        }

        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            return this.createTicker(level, type);
        }

        protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type) {
            return level.f_46443_ ? null : Tertium.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTileEntities.TERTIUM_FURNACE.get()), EssenceFurnaceTileEntity::tick);
        }
    }

    public static class Prudentium
    extends EssenceFurnaceBlock {
        public Prudentium() {
            super(FurnaceTier.PRUDENTIUM);
        }

        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            return this.createTicker(level, type);
        }

        protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type) {
            return level.f_46443_ ? null : Prudentium.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTileEntities.PRUDENTIUM_FURNACE.get()), EssenceFurnaceTileEntity::tick);
        }
    }

    public static class Inferium
    extends EssenceFurnaceBlock {
        public Inferium() {
            super(FurnaceTier.INFERIUM);
        }

        public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
            return this.createTicker(level, type);
        }

        protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type) {
            return level.f_46443_ ? null : Inferium.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTileEntities.INFERIUM_FURNACE.get()), EssenceFurnaceTileEntity::tick);
        }
    }
}

