/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.utils;

import li.cil.ceres.api.Serialized;

public final class SoftFloat {
    public static final int FLAG_INEXACT = 1;
    public static final int FLAG_UNDERFLOW = 2;
    public static final int FLAG_OVERFLOW = 4;
    public static final int FLAG_DIV_ZERO = 8;
    public static final int FLAG_INVALID = 16;
    public static final byte RM_RNE = 0;
    public static final byte RM_RTZ = 1;
    public static final byte RM_RDN = 2;
    public static final byte RM_RUP = 3;
    public static final byte RM_RMM = 4;
    public static final int FCLASS_NEGINF = 1;
    public static final int FCLASS_NEGNORM = 2;
    public static final int FCLASS_NEGSUBN = 4;
    public static final int FCLASS_NEGZERO = 8;
    public static final int FCLASS_POSZERO = 16;
    public static final int FCLASS_POSSUBN = 32;
    public static final int FCLASS_POSNORM = 64;
    public static final int FCLASS_POSINF = 128;
    public static final int FCLASS_SNAN = 256;
    public static final int FCLASS_QNAN = 512;
    public static final int SIZE = 32;
    public static final int EXPONENT_SIZE = 8;
    public static final int MANTISSA_SIZE = 23;
    public static final int SIGN_MASK = Integer.MIN_VALUE;
    public static final int EXPONENT_MASK = 255;
    public static final int MANTISSA_MASK = 0x7FFFFF;
    public static final int BIAS = 127;
    static final int INTERNAL_MANTISSA_SIZE = 30;
    private static final int RND_SIZE = 7;
    private static final int MANTISSA_IMPLICIT_BIT = 0x800000;
    private static final int QUIET_NAN_MASK = 0x400000;
    private static final int QUIET_NAN = 2143289344;
    public final Flags flags;

    public SoftFloat() {
        this.flags = new Flags();
    }

    public SoftFloat(Flags flags) {
        this.flags = flags;
    }

    public static int nan() {
        return 2143289344;
    }

    public static boolean isNaN(int a) {
        return (a >>> 23 & 0xFF) == 255 && (a & 0x7FFFFF) != 0;
    }

    public static boolean isInfinity(int a) {
        return (a >>> 23 & 0xFF) == 255 && (a & 0x7FFFFF) == 0;
    }

    public int sign(int a) {
        if (SoftFloat.isNaN(a)) {
            if (SoftFloat.isSignalingNaN(a)) {
                this.flags.raise(16);
            }
            return 0;
        }
        return (a & Integer.MIN_VALUE) == 0 ? 1 : -1;
    }

    public int neg(int a) {
        if (SoftFloat.isNaN(a)) {
            if (SoftFloat.isSignalingNaN(a)) {
                this.flags.raise(16);
            }
            return SoftFloat.nan();
        }
        return a ^ Integer.MIN_VALUE;
    }

    public int add(int a, int b, int rm) {
        int sign;
        int mantissa;
        if ((a & Integer.MAX_VALUE) < (b & Integer.MAX_VALUE)) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        int signA = SoftFloat.getSign(a);
        int signB = SoftFloat.getSign(b);
        int exponentA = SoftFloat.getExponent(a);
        int exponentB = SoftFloat.getExponent(b);
        int mantissaA = SoftFloat.getMantissa(a) << 3;
        int mantissaB = SoftFloat.getMantissa(b) << 3;
        if (exponentA == 255) {
            if (mantissaA != 0) {
                if (SoftFloat.isSignalingNaN(a) || SoftFloat.isSignalingNaN(b)) {
                    this.flags.raise(16);
                }
                return SoftFloat.nan();
            }
            if (exponentB == 255 && signA != signB) {
                this.flags.raise(16);
                return SoftFloat.nan();
            }
            return a;
        }
        if (exponentA == 0) {
            exponentA = 1;
        } else {
            mantissaA |= 0x4000000;
        }
        if (exponentB == 0) {
            exponentB = 1;
        } else {
            mantissaB |= 0x4000000;
        }
        mantissaB = SoftFloat.shiftRightAndJam(mantissaB, exponentA - exponentB);
        if (signA == signB) {
            mantissa = mantissaA + mantissaB;
            sign = signA;
        } else {
            mantissa = mantissaA - mantissaB;
            sign = mantissa == 0 ? (rm == 2 ? 1 : 0) : signA;
        }
        int exponent = exponentA + 4;
        return SoftFloat.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    public int sub(int a, int b, int rm) {
        return this.add(a, this.neg(b), rm);
    }

    public int mul(int a, int b, int rm) {
        int2 exponentAndMantissa;
        int signA = SoftFloat.getSign(a);
        int signB = SoftFloat.getSign(b);
        int exponentA = SoftFloat.getExponent(a);
        int exponentB = SoftFloat.getExponent(b);
        int mantissaA = SoftFloat.getMantissa(a);
        int mantissaB = SoftFloat.getMantissa(b);
        int sign = signA ^ signB;
        if (exponentA == 255 || exponentB == 255) {
            if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
                if (SoftFloat.isSignalingNaN(a) || SoftFloat.isSignalingNaN(b)) {
                    this.flags.raise(16);
                }
                return SoftFloat.nan();
            }
            if (exponentA == 255 && exponentB == 0 && mantissaB == 0 || exponentB == 255 && exponentA == 0 && mantissaA == 0) {
                this.flags.raise(16);
                return SoftFloat.nan();
            }
            return SoftFloat.pack(sign, 255, 0);
        }
        if (exponentA == 0) {
            if (mantissaA == 0) {
                return SoftFloat.pack(sign, 0, 0);
            }
            exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x800000;
        }
        if (exponentB == 0) {
            if (mantissaB == 0) {
                return SoftFloat.pack(sign, 0, 0);
            }
            exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaB);
            exponentB = exponentAndMantissa.a;
            mantissaB = exponentAndMantissa.b;
        } else {
            mantissaB |= 0x800000;
        }
        int exponent = exponentA + exponentB - 128 + 2;
        int2 mantissaHighAndLow = SoftFloat.multiply(mantissaA << 7, mantissaB << 8);
        int mantissa = mantissaHighAndLow.a | (mantissaHighAndLow.b != 0 ? 1 : 0);
        return SoftFloat.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    public int muladd(int a, int b, int c, int rm) {
        int tmp;
        int shift;
        int2 exponentAndMantissa;
        int signA = SoftFloat.getSign(a);
        int signB = SoftFloat.getSign(b);
        int signC = SoftFloat.getSign(c);
        int exponentA = SoftFloat.getExponent(a);
        int exponentB = SoftFloat.getExponent(b);
        int exponentC = SoftFloat.getExponent(c);
        int mantissaA = SoftFloat.getMantissa(a);
        int mantissaB = SoftFloat.getMantissa(b);
        int mantissaC = SoftFloat.getMantissa(c);
        int sign = signA ^ signB;
        if (exponentA == 255 || exponentB == 255 || exponentC == 255) {
            if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b) || SoftFloat.isNaN(c)) {
                if (SoftFloat.isSignalingNaN(a) || SoftFloat.isSignalingNaN(b) || SoftFloat.isSignalingNaN(c)) {
                    this.flags.raise(16);
                }
                return SoftFloat.nan();
            }
            if (exponentA == 255 && exponentB == 0 && mantissaB == 0 || exponentB == 255 && exponentA == 0 && mantissaA == 0 || (exponentA == 255 || exponentB == 255) && exponentC == 255 && sign != signC) {
                this.flags.raise(16);
                return SoftFloat.nan();
            }
            if (exponentC == 255) {
                return SoftFloat.pack(signC, 255, 0);
            }
            return SoftFloat.pack(sign, 255, 0);
        }
        if (exponentA == 0) {
            if (mantissaA == 0) {
                if (exponentC == 0 && mantissaC == 0) {
                    if (signC != sign) {
                        return SoftFloat.pack(rm == 2 ? 1 : 0, 0, 0);
                    }
                    return SoftFloat.pack(sign, 0, 0);
                }
                return c;
            }
            exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x800000;
        }
        if (exponentB == 0) {
            if (mantissaB == 0) {
                if (exponentC == 0 && mantissaC == 0) {
                    if (signC != sign) {
                        return SoftFloat.pack(rm == 2 ? 1 : 0, 0, 0);
                    }
                    return SoftFloat.pack(sign, 0, 0);
                }
                return c;
            }
            exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaB);
            exponentB = exponentAndMantissa.a;
            mantissaB = exponentAndMantissa.b;
        } else {
            mantissaB |= 0x800000;
        }
        int exponent = exponentA + exponentB - 128 + 3;
        int2 mantissaHighAndLow = SoftFloat.multiply(mantissaA << 7, mantissaB << 7);
        int mantissa0 = mantissaHighAndLow.b;
        int mantissa1 = mantissaHighAndLow.a;
        if (mantissa1 < 0x20000000) {
            mantissa1 = mantissa1 << 1 | mantissa0 >>> 31;
            mantissa0 <<= 1;
            --exponent;
        }
        if (exponentC == 0) {
            if (mantissaC == 0) {
                return SoftFloat.normalize(sign, exponent, mantissa1, rm, this.flags);
            }
            int2 exponentAndMantissa2 = SoftFloat.normalizeSubnormal(mantissaC);
            exponentC = exponentAndMantissa2.a;
            mantissaC = exponentAndMantissa2.b;
        } else {
            mantissaC |= 0x800000;
        }
        int mantissaC0 = 0;
        int mantissaC1 = mantissaC << 6;
        if (exponent <= ++exponentC && (exponent != exponentC || mantissa1 < mantissaC1)) {
            int tmp2 = mantissa0;
            mantissa0 = mantissaC0;
            mantissaC0 = tmp2;
            tmp2 = mantissa1;
            mantissa1 = mantissaC1;
            mantissaC1 = tmp2;
            tmp2 = exponent;
            exponent = exponentC;
            exponentC = tmp2;
            tmp2 = sign;
            sign = signC;
            signC = tmp2;
        }
        if ((shift = exponent - exponentC) >= 64) {
            mantissaC0 = (mantissaC0 | mantissaC1) != 0 ? 1 : 0;
            mantissaC1 = 0;
        } else if (shift >= 33) {
            mantissaC0 = SoftFloat.shiftRightAndJam(mantissaC1, shift - 32);
            mantissaC1 = 0;
        } else if (shift == 32) {
            mantissaC0 = mantissaC1 | (mantissaC0 != 0 ? 1 : 0);
            mantissaC1 = 0;
        } else if (shift != 0) {
            mantissaC0 = mantissaC1 << 32 - shift | mantissaC0 >> shift | ((mantissaC0 & (1 << shift) - 1) != 0 ? 1 : 0);
            mantissaC1 >>>= shift;
        }
        if (sign == signC) {
            mantissa1 += mantissaC1 + ((mantissa0 += mantissaC0) < mantissaC0 ? 1 : 0);
        } else if ((mantissa0 | (mantissa1 = mantissa1 - mantissaC1 - ((mantissa0 -= mantissaC0) > (tmp = mantissa0) ? 1 : 0))) == 0) {
            sign = rm == 2 ? 1 : 0;
        }
        return SoftFloat.normalize(sign, exponent, mantissa0, mantissa1, rm, this.flags);
    }

    public int mulsub(int a, int b, int c, int rm) {
        return this.muladd(a, b, this.neg(c), rm);
    }

    public int div(int a, int b, int rm) {
        int2 exponentAndMantissa;
        int signA = SoftFloat.getSign(a);
        int signB = SoftFloat.getSign(b);
        int exponentA = SoftFloat.getExponent(a);
        int exponentB = SoftFloat.getExponent(b);
        int mantissaA = SoftFloat.getMantissa(a);
        int mantissaB = SoftFloat.getMantissa(b);
        int sign = signA ^ signB;
        if (exponentA == 255 || exponentB == 255) {
            if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
                if (SoftFloat.isSignalingNaN(a) || SoftFloat.isSignalingNaN(b)) {
                    this.flags.raise(16);
                }
                return SoftFloat.nan();
            }
            if (exponentA == 255 && exponentB == 255) {
                this.flags.raise(16);
                return SoftFloat.nan();
            }
            if (exponentA == 255) {
                return SoftFloat.pack(sign, 255, 0);
            }
            return SoftFloat.pack(sign, 0, 0);
        }
        if (exponentB == 0) {
            if (mantissaB == 0) {
                if (exponentA == 0 && mantissaA == 0) {
                    this.flags.raise(16);
                    return SoftFloat.nan();
                }
                this.flags.raise(8);
                return SoftFloat.pack(sign, 255, 0);
            }
            exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaB);
            exponentB = exponentAndMantissa.a;
            mantissaB = exponentAndMantissa.b;
        } else {
            mantissaB |= 0x800000;
        }
        if (exponentA == 0) {
            if (mantissaA == 0) {
                return SoftFloat.pack(sign, 0, 0);
            }
            exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x800000;
        }
        int exponent = exponentA - exponentB + 128 - 1;
        int2 mantissaAndRemainder = SoftFloat.divideAndRemainder(mantissaA, mantissaB << 2);
        int mantissa = mantissaAndRemainder.a | (mantissaAndRemainder.b != 0 ? 1 : 0);
        return SoftFloat.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    public int sqrt(int a, int rm) {
        int signA = SoftFloat.getSign(a);
        int exponentA = SoftFloat.getExponent(a);
        int mantissaA = SoftFloat.getMantissa(a);
        if (exponentA == 255) {
            if (SoftFloat.isNaN(a)) {
                if (SoftFloat.isSignalingNaN(a)) {
                    this.flags.raise(16);
                }
                return SoftFloat.nan();
            }
            if (signA == 1) {
                this.flags.raise(16);
                return SoftFloat.nan();
            }
            return a;
        }
        if (signA == 1) {
            if (exponentA == 0 && mantissaA == 0) {
                return a;
            }
            this.flags.raise(16);
            return SoftFloat.nan();
        }
        if (exponentA == 0) {
            if (mantissaA == 0) {
                return SoftFloat.pack(0, 0, 0);
            }
            int2 exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x800000;
        }
        if (((exponentA -= 127) & 1) != 0) {
            --exponentA;
            mantissaA <<= 1;
        }
        exponentA = (exponentA >> 1) + 127;
        int2 sqrtAndInexact = SoftFloat.sqrtAndRemainder(mantissaA <<= 5);
        mantissaA = sqrtAndInexact.a;
        if (sqrtAndInexact.b != 0) {
            mantissaA |= 1;
        }
        return SoftFloat.normalize(signA, exponentA, mantissaA, rm, this.flags);
    }

    public int min(int a, int b) {
        int signB;
        if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
            return this.handleMinMaxNaN(a, b);
        }
        int signA = SoftFloat.getSign(a);
        if (signA != (signB = SoftFloat.getSign(b))) {
            if (signA != 0) {
                return a;
            }
            return b;
        }
        if (Integer.compareUnsigned(a, b) < 0 ^ signA != 0) {
            return a;
        }
        return b;
    }

    public int max(int a, int b) {
        int signB;
        if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
            return this.handleMinMaxNaN(a, b);
        }
        int signA = SoftFloat.getSign(a);
        if (signA != (signB = SoftFloat.getSign(b))) {
            if (signA != 0) {
                return b;
            }
            return a;
        }
        if (Integer.compareUnsigned(a, b) < 0 ^ signA != 0) {
            return b;
        }
        return a;
    }

    public boolean equals(int a, int b) {
        if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
            if (SoftFloat.isSignalingNaN(a) || SoftFloat.isSignalingNaN(b)) {
                this.flags.raise(16);
            }
            return false;
        }
        if ((a | b) << 1 == 0) {
            return true;
        }
        return a == b;
    }

    public boolean lessOrEqual(int a, int b) {
        int signB;
        if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
            this.flags.raise(16);
            return false;
        }
        int signA = SoftFloat.getSign(a);
        if (signA != (signB = SoftFloat.getSign(b))) {
            return signA != 0 || (a | b) << 1 == 0;
        }
        if (signA != 0) {
            return a >= b;
        }
        return a <= b;
    }

    public boolean lessThan(int a, int b) {
        int signB;
        if (SoftFloat.isNaN(a) || SoftFloat.isNaN(b)) {
            this.flags.raise(16);
            return false;
        }
        int signA = SoftFloat.getSign(a);
        if (signA != (signB = SoftFloat.getSign(b))) {
            return signA != 0 && (a | b) << 1 != 0;
        }
        if (signA != 0) {
            return a > b;
        }
        return a < b;
    }

    public int classify(int a) {
        int signA = SoftFloat.getSign(a);
        int exponentA = SoftFloat.getExponent(a);
        int mantissaA = SoftFloat.getMantissa(a);
        if (exponentA == 255) {
            if (mantissaA == 0) {
                if (signA != 0) {
                    return 1;
                }
                return 128;
            }
            if ((mantissaA & 0x400000) != 0) {
                return 512;
            }
            return 256;
        }
        if (exponentA == 0) {
            if (mantissaA == 0) {
                if (signA != 0) {
                    return 8;
                }
                return 16;
            }
            if (signA != 0) {
                return 4;
            }
            return 32;
        }
        if (signA != 0) {
            return 2;
        }
        return 64;
    }

    public int intToFloat(int a, int rm) {
        return this.longToFloat(a, rm, false);
    }

    public int unsignedIntToFloat(int a, int rm) {
        return this.longToFloat((long)a & 0xFFFFFFFFL, rm, true);
    }

    public int floatToInt(int a, int rm) {
        return (int)this.floatToInt(a, rm, 32, false);
    }

    public int floatToUnsignedInt(int a, int rm) {
        return (int)this.floatToInt(a, rm, 32, true);
    }

    public int longToFloat(long a, int rm) {
        return this.longToFloat(a, rm, false);
    }

    public int unsignedLongToFloat(long a, int rm) {
        return this.longToFloat(a, rm, true);
    }

    public long floatToLong(int a, int rm) {
        return this.floatToInt(a, rm, 64, false);
    }

    public long floatToUnsignedLong(int a, int rm) {
        return this.floatToInt(a, rm, 64, true);
    }

    private int longToFloat(long a, int rm, boolean isUnsigned) {
        long mantissa;
        int sign;
        if (!isUnsigned && a < 0L) {
            sign = 1;
            mantissa = -a;
        } else {
            sign = 0;
            mantissa = a;
        }
        int exponent = 157;
        int l = 64 - Long.numberOfLeadingZeros(mantissa) - 31;
        if (l > 0) {
            long mask = (1L << l) - 1L;
            mantissa = mantissa >>> l | (long)((mantissa & mask) != 0L ? 1 : 0);
            exponent += l;
        }
        return SoftFloat.normalize(sign, exponent, (int)mantissa, rm, this.flags);
    }

    /*
     * Enabled aggressive block sorting
     */
    private long floatToInt(int a, int rm, int intSize, boolean isUnsigned) {
        long result;
        int sign = SoftFloat.getSign(a);
        int exponent = SoftFloat.getExponent(a);
        int mantissa = SoftFloat.getMantissa(a);
        if (exponent == 255 && mantissa != 0) {
            sign = 0;
        }
        if (exponent == 0) {
            exponent = 1;
        } else {
            mantissa |= 0x800000;
        }
        mantissa <<= 7;
        exponent = exponent - 127 - 23;
        long max = isUnsigned ? (long)sign - 1L >>> 64 - intSize : (1L << intSize - 1) - (long)(sign ^ 1);
        if (exponent >= 0) {
            if (exponent > intSize - 1 - 23) {
                this.flags.raise(16);
                return max;
            }
            result = ((long)mantissa & 0xFFFFFFFFL) >>> 7 << exponent;
            if (Long.compareUnsigned(result, max) > 0) {
                this.flags.raise(16);
                return max;
            }
        } else {
            mantissa = SoftFloat.shiftRightAndJam(mantissa, -exponent);
            int addend = switch (rm) {
                case 0, 4 -> 64;
                case 1 -> 0;
                case 2, 3 -> {
                    if (sign == 0 ? rm == 2 : rm == 3) {
                        yield 127;
                    }
                    yield 0;
                }
                default -> throw new IllegalArgumentException();
            };
            int rnd_bits = mantissa & 0x7F;
            mantissa = mantissa + addend >>> 7;
            if (rm == 0 && rnd_bits == 64) {
                mantissa &= 0xFFFFFFFE;
            }
            if (Long.compareUnsigned((long)mantissa & 0xFFFFFFFFL, max) > 0) {
                this.flags.raise(16);
                return max;
            }
            result = mantissa;
            if (rnd_bits != 0) {
                this.flags.raise(1);
            }
        }
        if (sign == 0) return result;
        return -result;
    }

    private static int2 multiply(int a, int b) {
        long r = Integer.toUnsignedLong(a) * Integer.toUnsignedLong(b);
        return int2.of((int)(r >>> 32), (int)r);
    }

    private static int2 divideAndRemainder(int ah, int b) {
        long a = Integer.toUnsignedLong(ah) << 32;
        return int2.of((int)(a / (long)b), (int)(a % (long)b));
    }

    private static int2 sqrtAndRemainder(int ah) {
        long s;
        if (ah == 0) {
            return int2.of(0, 0);
        }
        int l = 64 - Integer.numberOfLeadingZeros(ah - 1);
        long a = Integer.toUnsignedLong(ah) << 32;
        long u = 1L << (l + 1) / 2;
        while ((u = (a / (s = u) + s) / 2L) < s) {
        }
        return int2.of((int)s, a - s * s != 0L ? 1 : 0);
    }

    private int handleMinMaxNaN(int a, int b) {
        if (SoftFloat.isSignalingNaN(a) || SoftFloat.isSignalingNaN(b)) {
            this.flags.raise(16);
        }
        if (SoftFloat.isNaN(a)) {
            if (SoftFloat.isNaN(b)) {
                return SoftFloat.nan();
            }
            return b;
        }
        return a;
    }

    static boolean isSignalingNaN(int a) {
        return SoftFloat.isNaN(a) && (a & 0x400000) == 0;
    }

    static int2 normalizeSubnormal(int mantissa) {
        int shift = 23 - (31 - Integer.numberOfLeadingZeros(mantissa));
        return int2.of(1 - shift, mantissa << shift);
    }

    static int normalize(int sign, int exponent, int mantissa, int rm, Flags flags) {
        int shift = Integer.numberOfLeadingZeros(mantissa) - 1;
        assert (shift >= 0);
        return SoftFloat.round(sign, exponent - shift, mantissa << shift, rm, flags);
    }

    private static int normalize(int sign, int exponent, int mantissa0, int mantissa1, int rm, Flags flags) {
        int l = mantissa1 == 0 ? 32 + Integer.numberOfLeadingZeros(mantissa0) : Integer.numberOfLeadingZeros(mantissa1);
        int shift = l - 1;
        assert (shift >= 0);
        int mantissa = shift == 0 ? mantissa1 | (mantissa0 != 0 ? 1 : 0) : (shift < 32 ? mantissa1 << shift | mantissa0 >>> 32 - shift | (mantissa0 << shift != 0 ? 1 : 0) : mantissa0 << shift - 32);
        return SoftFloat.round(sign, exponent - shift, mantissa, rm, flags);
    }

    private static int round(int sign, int exponent, int mantissa, int rm, Flags flags) {
        int rnd_bits;
        int addend = switch (rm) {
            case 0, 4 -> 64;
            case 1 -> 0;
            case 2, 3 -> {
                if (sign == 0 ? rm == 2 : rm == 3) {
                    yield 127;
                }
                yield 0;
            }
            default -> throw new IllegalArgumentException();
        };
        if (exponent <= 0) {
            int min = Integer.MIN_VALUE;
            boolean isSubnormal = exponent < 0 || Integer.compareUnsigned(mantissa + addend, Integer.MIN_VALUE) < 0;
            int diff = 1 - exponent;
            mantissa = SoftFloat.shiftRightAndJam(mantissa, diff);
            rnd_bits = mantissa & 0x7F;
            if (isSubnormal && rnd_bits != 0) {
                flags.raise(2);
            }
            exponent = 1;
        } else {
            rnd_bits = mantissa & 0x7F;
        }
        if (rnd_bits != 0) {
            flags.raise(1);
        }
        mantissa = mantissa + addend >>> 7;
        if (rm == 0 && rnd_bits == 64) {
            mantissa &= 0xFFFFFFFE;
        }
        exponent += mantissa >>> 24;
        if (mantissa <= 0x7FFFFF) {
            exponent = 0;
        } else if (exponent >= 255) {
            if (addend == 0) {
                exponent = 254;
                mantissa = 0x7FFFFF;
            } else {
                exponent = 255;
                mantissa = 0;
            }
            flags.raise(5);
        }
        return SoftFloat.pack(sign, exponent, mantissa);
    }

    private static int shiftRightAndJam(int a, int d) {
        if (d == 0) {
            return a;
        }
        if (d >= 32) {
            return a != 0 ? 1 : 0;
        }
        return a >>> d | ((a & (1 << d) - 1) != 0 ? 1 : 0);
    }

    static int pack(int sign, int exponent, int mantissa) {
        return sign << 31 | exponent << 23 | mantissa & 0x7FFFFF;
    }

    static int getSign(int a) {
        return a >>> 31;
    }

    static int getExponent(int a) {
        return a >>> 23 & 0xFF;
    }

    static int getMantissa(int a) {
        return a & 0x7FFFFF;
    }

    @Serialized
    public static final class Flags {
        public byte value;

        void raise(int mask) {
            this.value = (byte)(this.value | mask);
        }
    }

    static final class int2 {
        private static final ThreadLocal<int2> INSTANCE = ThreadLocal.withInitial(int2::new);
        public int a;
        public int b;

        int2() {
        }

        public static int2 of(int a, int b) {
            int2 instance = INSTANCE.get();
            instance.a = a;
            instance.b = b;
            return instance;
        }
    }
}

