/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.utils;

import java.math.BigInteger;

public final class BitUtils {
    public static int getField(int value, int srcBitFrom, int srcBitUntil, int destBit) {
        return (destBit >= srcBitFrom ? value << destBit - srcBitFrom : value >>> srcBitFrom - destBit) & (1 << srcBitUntil - srcBitFrom + 1) - 1 << destBit;
    }

    public static int extendSign(int value, int width) {
        return value << 32 - width >> 32 - width;
    }

    public static long maskFromRange(int bitFrom, int bitUntil) {
        return (1L << bitUntil - bitFrom + 1) - 1L << bitFrom;
    }

    public static BigInteger unsignedLongToBigInteger(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        int upper = (int)(value >>> 32);
        int lower = (int)value;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).or(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }
}

