/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.serialization.serializers;

import javax.annotation.Nullable;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import li.cil.ceres.api.Serializer;
import li.cil.sedna.device.block.SparseBlockDevice;

public final class SparseBlockMapSerializer
implements Serializer<SparseBlockDevice.SparseBlockMap> {
    @Override
    public void serialize(SerializationVisitor visitor, Class<SparseBlockDevice.SparseBlockMap> type, Object value) throws SerializationException {
        SparseBlockDevice.SparseBlockMap map = (SparseBlockDevice.SparseBlockMap)((Object)value);
        int[] keys = map.keySet().toArray(new int[0]);
        byte[][] values = new byte[map.size()][];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = (byte[])map.get(keys[i]);
        }
        visitor.putObject("keys", int[].class, keys);
        visitor.putObject("values", byte[][].class, values);
    }

    @Override
    public SparseBlockDevice.SparseBlockMap deserialize(DeserializationVisitor visitor, Class<SparseBlockDevice.SparseBlockMap> type, @Nullable Object value) throws SerializationException {
        SparseBlockDevice.SparseBlockMap map = (SparseBlockDevice.SparseBlockMap)((Object)value);
        if (!visitor.exists("keys") || !visitor.exists("values")) {
            return map;
        }
        int[] keys = (int[])visitor.getObject("keys", int[].class, null);
        byte[][] values = (byte[][])visitor.getObject("values", byte[][].class, null);
        if (keys == null || values == null) {
            return null;
        }
        if (map == null) {
            map = new SparseBlockDevice.SparseBlockMap(keys.length);
        } else {
            map.clear();
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
        }
        return map;
    }
}

