/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv.devicetree;

import java.util.Optional;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryMap;

public final class R5PlatformLevelInterruptControllerProvider
implements DeviceTreeProvider {
    @Override
    public Optional<String> getName(Device device) {
        return Optional.of("plic");
    }

    @Override
    public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
        Optional<MappedMemoryRange> range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        return range.map(r -> root.find("/soc").getChild(deviceName, r.address()));
    }

    @Override
    public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
        node.addProp("#address-cells", 0).addProp("#interrupt-cells", 1).addProp("interrupt-controller", new Object[0]).addProp("compatible", "riscv,plic0").addProp("riscv,ndev", 31).addProp("phandle", node.getPHandle(device));
    }
}

