/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.api.memory.MemoryRange;
import li.cil.sedna.api.memory.MemoryRangeAllocationStrategy;

public final class R5MemoryRangeAllocationStrategy
implements MemoryRangeAllocationStrategy {
    public static final long PHYSICAL_MEMORY_FIRST = 0x80000000L;
    public static final long PHYSICAL_MEMORY_LAST = 0xFFFFFFFFL;
    public static final long DEVICE_MEMORY_FIRST = 0x10000000L;
    public static final long DEVICE_MEMORY_LAST = Integer.MAX_VALUE;

    @Override
    public OptionalLong findMemoryRange(MemoryMappedDevice device, Function<MemoryRange, Optional<? extends MemoryRange>> intersectProvider) {
        return this.findMemoryRange(device, intersectProvider, 0L);
    }

    @Override
    public OptionalLong findMemoryRange(MemoryMappedDevice device, Function<MemoryRange, Optional<? extends MemoryRange>> intersectProvider, long start) {
        long end;
        long clampedStart;
        if (device.getLength() == 0) {
            return OptionalLong.empty();
        }
        if (device instanceof PhysicalMemory) {
            clampedStart = Math.max(0x80000000L, Math.min(0xFFFFFFFFL, start));
            end = 0xFFFFFFFFL - (long)device.getLength() + 1L;
        } else {
            clampedStart = Math.max(0x10000000L, Math.min(Integer.MAX_VALUE, start));
            end = Integer.MAX_VALUE - (long)device.getLength() + 1L;
        }
        return this.findFreeRange(clampedStart, end, device.getLength(), intersectProvider);
    }

    private OptionalLong findFreeRange(long start, long end, int size, Function<MemoryRange, Optional<? extends MemoryRange>> intersectProvider) {
        MemoryRange candidateRange;
        Optional<? extends MemoryRange> intersect;
        if (size == 0) {
            return OptionalLong.empty();
        }
        if (Long.compareUnsigned(end, start) < 0) {
            return OptionalLong.empty();
        }
        if (Long.compareUnsigned(end - start, size - 1) < 0) {
            return OptionalLong.empty();
        }
        if (Long.compareUnsigned(start, -1L - (long)size) > 0) {
            return OptionalLong.empty();
        }
        int alignment = (int)(start % 8L);
        if (alignment != 0) {
            start += (long)(8 - alignment);
        }
        if ((intersect = intersectProvider.apply(candidateRange = MemoryRange.at(start, size))).isPresent()) {
            long intersectEnd = intersect.get().end;
            if (intersectEnd != -1L) {
                return this.findFreeRange(intersectEnd + 1L, end, size, intersectProvider);
            }
            return OptionalLong.empty();
        }
        return OptionalLong.of(start);
    }
}

