/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.InstructionDeclarationLoader;
import li.cil.sedna.instruction.InstructionDefinition;
import li.cil.sedna.instruction.InstructionDefinitionLoader;
import li.cil.sedna.instruction.decoder.DecoderTree;
import li.cil.sedna.instruction.decoder.PrintStreamDecoderTreeVisitor;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;
import li.cil.sedna.riscv.R5CPUTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class R5Instructions {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Spec RV32 = new Spec("/riscv/instructions32.txt");
    public static final Spec RV64 = new Spec("/riscv/instructions64.txt");

    @Nullable
    public static InstructionDefinition getDefinition(InstructionDeclaration declaration) {
        return RV64.getDefinition(declaration);
    }

    public static AbstractDecoderTreeNode getDecoderTree() {
        return RV64.getDecoderTree();
    }

    public static void main(String[] args) {
        AbstractDecoderTreeNode tree = RV64.getDecoderTree();
        tree.accept(new PrintStreamDecoderTreeVisitor(tree.getMaxDepth()));
    }

    public static final class Spec {
        private final ArrayList<InstructionDeclaration> DECLARATIONS = new ArrayList();
        private final HashMap<InstructionDeclaration, InstructionDefinition> DEFINITIONS = new HashMap();
        private final AbstractDecoderTreeNode DECODER_TREE;

        public Spec(String instructionsFile) {
            try (InputStream stream = R5Instructions.class.getResourceAsStream(instructionsFile);){
                if (stream == null) {
                    throw new IOException("File not found.");
                }
                this.DECLARATIONS.addAll(InstructionDeclarationLoader.load(stream));
            }
            catch (Throwable e) {
                LOGGER.error("Failed loading RISC-V instruction declarations.", e);
            }
            try {
                this.DEFINITIONS.putAll(InstructionDefinitionLoader.load(R5CPUTemplate.class, this.DECLARATIONS));
            }
            catch (Throwable e) {
                LOGGER.error("Failed loading RISC-V instruction definitions.", e);
            }
            this.DECODER_TREE = DecoderTree.create(this.DECLARATIONS);
        }

        public ArrayList<InstructionDeclaration> getDeclarations() {
            return this.DECLARATIONS;
        }

        @Nullable
        public InstructionDefinition getDefinition(InstructionDeclaration declaration) {
            return this.DEFINITIONS.get(declaration);
        }

        public AbstractDecoderTreeNode getDecoderTree() {
            return this.DECODER_TREE;
        }
    }
}

