/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.api.memory.MemoryRange;

public final class SimpleMemoryMap
implements MemoryMap {
    private final Map<MemoryMappedDevice, MappedMemoryRange> devices = new HashMap<MemoryMappedDevice, MappedMemoryRange>();
    private MappedMemoryRange cache;

    @Override
    public boolean addDevice(long address, MemoryMappedDevice device) {
        if (this.devices.containsKey(device)) {
            return false;
        }
        MappedMemoryRange deviceRange = new MappedMemoryRange(device, address);
        if (this.devices.values().stream().anyMatch(range -> range.intersects(deviceRange))) {
            return false;
        }
        this.devices.put(device, deviceRange);
        return true;
    }

    @Override
    public void removeDevice(MemoryMappedDevice device) {
        this.devices.remove(device);
        if (this.cache != null && this.cache.device == device) {
            this.cache = null;
        }
    }

    @Override
    public Optional<MappedMemoryRange> getMemoryRange(MemoryMappedDevice device) {
        return Optional.ofNullable(this.devices.get(device));
    }

    @Override
    public Optional<MappedMemoryRange> getMemoryRange(MemoryRange range) {
        for (MappedMemoryRange existingRange : this.devices.values()) {
            if (!existingRange.intersects(range)) continue;
            return Optional.of(existingRange);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public MappedMemoryRange getMemoryRange(long address) {
        MappedMemoryRange cachedValue = this.cache;
        if (cachedValue != null && cachedValue.contains(address)) {
            return cachedValue;
        }
        for (MappedMemoryRange range : this.devices.values()) {
            if (!range.contains(address)) continue;
            this.cache = range;
            return range;
        }
        return null;
    }

    @Override
    public void setDirty(MemoryRange range, int offset) {
    }

    @Override
    public long load(long address, int sizeLog2) throws MemoryAccessException {
        MappedMemoryRange range = this.getMemoryRange(address);
        if (range != null && (range.device.getSupportedSizes() & 1 << sizeLog2) != 0) {
            return range.device.load((int)(address - range.start), sizeLog2);
        }
        return 0L;
    }

    @Override
    public void store(long address, long value, int sizeLog2) throws MemoryAccessException {
        MappedMemoryRange range = this.getMemoryRange(address);
        if (range != null && (range.device.getSupportedSizes() & 1 << sizeLog2) != 0) {
            range.device.store((int)(address - range.start), value, sizeLog2);
        }
    }
}

