/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.decoder.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.argument.FieldInstructionArgument;
import li.cil.sedna.instruction.decoder.DecoderTreeLeafVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeNodeArguments;
import li.cil.sedna.instruction.decoder.DecoderTreeVisitor;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;

public final class DecoderTreeLeafNode
extends AbstractDecoderTreeNode {
    public final InstructionDeclaration declaration;

    public DecoderTreeLeafNode(InstructionDeclaration declaration) {
        this.declaration = declaration;
    }

    @Override
    public int getMaxDepth() {
        return 0;
    }

    @Override
    public int getMask() {
        return this.declaration.patternMask;
    }

    @Override
    public int getPattern() {
        return this.declaration.pattern;
    }

    @Override
    public DecoderTreeNodeArguments getArguments() {
        HashMap<FieldInstructionArgument, ArrayList> argumentNames = new HashMap<FieldInstructionArgument, ArrayList>();
        this.declaration.arguments.forEach((key, argument) -> {
            if (argument instanceof FieldInstructionArgument) {
                argumentNames.computeIfAbsent((FieldInstructionArgument)argument, arg -> new ArrayList()).add(key);
            }
        });
        HashMap<FieldInstructionArgument, DecoderTreeNodeArguments.Entry> arguments = new HashMap<FieldInstructionArgument, DecoderTreeNodeArguments.Entry>();
        argumentNames.forEach((key, value) -> arguments.put((FieldInstructionArgument)key, new DecoderTreeNodeArguments.Entry(1, (ArrayList<String>)value)));
        return new DecoderTreeNodeArguments(1, arguments);
    }

    @Override
    public Stream<InstructionDeclaration> getInstructions() {
        return Stream.of(this.declaration);
    }

    @Override
    @Nullable
    public InstructionDeclaration query(int instruction) {
        if ((instruction & this.declaration.patternMask) == this.declaration.pattern) {
            return this.declaration;
        }
        return null;
    }

    @Override
    public void accept(DecoderTreeVisitor visitor) {
        DecoderTreeLeafVisitor instructionVisitor = visitor.visitInstruction();
        if (instructionVisitor != null) {
            instructionVisitor.visitInstruction(this.declaration);
            instructionVisitor.visitEnd();
        }
        visitor.visitEnd();
    }

    public String toString() {
        return this.declaration.toString();
    }
}

