/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.decoder;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeBranchNode;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeLeafNode;
import li.cil.sedna.instruction.decoder.tree.DecoderTreeSwitchNode;

public final class DecoderTree {
    public static AbstractDecoderTreeNode create(ArrayList<InstructionDeclaration> declarations) {
        return DecoderTree.postProcess(DecoderTree.create(declarations, -1));
    }

    /*
     * WARNING - void declaration
     */
    static AbstractDecoderTreeNode create(ArrayList<InstructionDeclaration> declarations, int groupMask) {
        if (declarations.size() == 1) {
            InstructionDeclaration declaration = declarations.get(0);
            if (declaration.patternMask != groupMask) {
                return new DecoderTreeBranchNode(new DecoderTreeLeafNode[]{new DecoderTreeLeafNode(declaration)});
            }
            return new DecoderTreeLeafNode(declaration);
        }
        int maskIntersect = -1;
        for (InstructionDeclaration instructionDeclaration : declarations) {
            maskIntersect &= instructionDeclaration.patternMask;
        }
        Int2ObjectArrayMap groups = new Int2ObjectArrayMap();
        for (InstructionDeclaration declaration : declarations) {
            int maskedPattern = declaration.pattern & maskIntersect;
            ((ArrayList)groups.computeIfAbsent(maskedPattern, i -> new ArrayList())).add(declaration);
        }
        if (groups.size() == 1) {
            void var4_8;
            declarations.sort(Comparator.comparingInt(o -> -Integer.bitCount(o.patternMask)));
            boolean bl = false;
            while (var4_8 < declarations.size()) {
                InstructionDeclaration moreSpecific = declarations.get((int)var4_8);
                int maskMoreSpecific = moreSpecific.patternMask;
                for (void j = var4_8 + true; j < declarations.size(); ++j) {
                    InstructionDeclaration lessSpecific = declarations.get((int)j);
                    int maskLessSpecific = lessSpecific.patternMask;
                    if ((maskLessSpecific & maskMoreSpecific) == maskLessSpecific) continue;
                    int localMaskA = maskMoreSpecific & ~maskIntersect;
                    int localMaskB = maskLessSpecific & ~maskIntersect;
                    int overlapMask = localMaskA | localMaskB;
                    assert ((moreSpecific.pattern & overlapMask) == (lessSpecific.pattern & overlapMask)) : "Expected overlapping patterns to match or have landed in different groups otherwise.";
                    int patternA = localMaskA & moreSpecific.pattern;
                    int patternB = localMaskB & lessSpecific.pattern;
                    int patternAB = patternA | patternB;
                    boolean ambiguousCaseHandledByMoreSpecificDeclaration = false;
                    for (void k = var4_8 - true; k >= 0; --k) {
                        InstructionDeclaration mostSpecific = declarations.get((int)k);
                        assert ((mostSpecific.patternMask & overlapMask) == overlapMask) : "Expecting more specific patterns to fully contain less specific patterns.";
                        int mostSpecificPattern = mostSpecific.pattern & overlapMask;
                        if (mostSpecificPattern != patternAB) continue;
                        ambiguousCaseHandledByMoreSpecificDeclaration = true;
                        break;
                    }
                    if (ambiguousCaseHandledByMoreSpecificDeclaration) continue;
                    throw new IllegalArgumentException(String.format("Instructions [%s] (line %d) and [%s] (line %d) have ambiguous bit pattern.", moreSpecific.displayName, moreSpecific.lineNumber, lessSpecific.displayName, lessSpecific.lineNumber));
                }
                ++var4_8;
            }
            return new DecoderTreeBranchNode((AbstractDecoderTreeNode[])declarations.stream().map(DecoderTreeLeafNode::new).toArray(DecoderTreeLeafNode[]::new));
        }
        int[] nArray = groups.keySet().toIntArray();
        DecoderTree.sortUnsigned(nArray);
        AbstractDecoderTreeNode[] children = new AbstractDecoderTreeNode[nArray.length];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            children[i3] = DecoderTree.create((ArrayList)groups.get(nArray[i3]), maskIntersect);
        }
        return new DecoderTreeSwitchNode(children);
    }

    private static void sortUnsigned(int[] values) {
        int i;
        int length = values.length;
        for (i = 0; i < length; ++i) {
            values[i] = values[i] ^ Integer.MIN_VALUE;
        }
        Arrays.sort(values);
        for (i = 0; i < length; ++i) {
            values[i] = values[i] ^ Integer.MIN_VALUE;
        }
    }

    private static AbstractDecoderTreeNode postProcess(AbstractDecoderTreeNode node) {
        block4: {
            block3: {
                if (!(node instanceof DecoderTreeSwitchNode)) break block3;
                DecoderTreeSwitchNode switchNode = (DecoderTreeSwitchNode)node;
                if (switchNode.children.length < 3) {
                    return new DecoderTreeBranchNode(switchNode.children);
                }
                for (int i = 0; i < switchNode.children.length; ++i) {
                    switchNode.children[i] = DecoderTree.postProcess(switchNode.children[i]);
                }
                break block4;
            }
            if (!(node instanceof DecoderTreeBranchNode)) break block4;
            DecoderTreeBranchNode branchNode = (DecoderTreeBranchNode)node;
            for (int i = 0; i < branchNode.children.length; ++i) {
                branchNode.children[i] = DecoderTree.postProcess(branchNode.children[i]);
            }
        }
        return node;
    }
}

