/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.InstructionDefinition;
import li.cil.sedna.instruction.InstructionType;
import li.cil.sedna.instruction.argument.ConstantInstructionArgument;
import li.cil.sedna.instruction.argument.InstructionArgument;
import li.cil.sedna.instruction.argument.ProgramCounterInstructionArgument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class InstructionDefinitionLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static HashMap<InstructionDeclaration, InstructionDefinition> load(final Class<?> implementation, ArrayList<InstructionDeclaration> declarations) throws IOException {
        HashMap<InstructionDeclaration, InstructionDefinition> definitions = new HashMap<InstructionDeclaration, InstructionDefinition>();
        final ArrayList<InstructionFunctionVisitor> visitors = new ArrayList<InstructionFunctionVisitor>();
        try (InputStream stream = implementation.getClassLoader().getResourceAsStream(implementation.getName().replace('.', '/') + ".class");){
            if (stream == null) {
                throw new IOException("Could not load class file for class [" + implementation + "].");
            }
            ClassReader cr = new ClassReader(stream);
            cr.accept(new ClassVisitor(458752){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    InstructionFunctionVisitor visitor = new InstructionFunctionVisitor(implementation, name, descriptor, exceptions);
                    visitors.add(visitor);
                    return visitor;
                }
            }, 0);
        }
        visitors.removeIf(v -> !v.isImplementation);
        ArrayList<NonStaticMethodInvocation> knownMethodInvocations = new ArrayList<NonStaticMethodInvocation>();
        HashMap<String, InstructionFunctionVisitor> visitorByInstructionName = new HashMap<String, InstructionFunctionVisitor>();
        for (InstructionFunctionVisitor visitor : visitors) {
            if (visitor.instructionName == null || visitor.instructionName.isEmpty()) {
                throw new IllegalArgumentException(String.format("Instruction definition on [%s] has no name.", visitor.name));
            }
            visitor.resolveInvokedMethods(knownMethodInvocations);
            if (visitorByInstructionName.containsKey(visitor.instructionName)) {
                LOGGER.warn("Duplicate instruction definitions for instruction [{}]. Using [{}].", (Object)visitor.instructionName, (Object)visitor.name);
                continue;
            }
            visitorByInstructionName.put(visitor.instructionName, visitor);
        }
        for (InstructionDeclaration declaration : declarations) {
            boolean returnsBoolean;
            if (declaration.type == InstructionType.ILLEGAL || declaration.type == InstructionType.NOP) continue;
            InstructionFunctionVisitor visitor = (InstructionFunctionVisitor)((Object)visitorByInstructionName.get(declaration.name));
            if (visitor == null) {
                LOGGER.warn("No instruction definition for instruction declaration [{}].", (Object)declaration.displayName);
                continue;
            }
            Type returnType = Type.getReturnType((String)visitor.descriptor);
            if (Objects.equals(Type.BOOLEAN_TYPE, returnType)) {
                returnsBoolean = true;
            } else {
                returnsBoolean = false;
                if (!Objects.equals(Type.VOID_TYPE, returnType)) {
                    throw new IllegalArgumentException(String.format("Instruction definition [%s] return type is neither boolean nor void.", visitor.name));
                }
            }
            Type[] argumentTypes = Type.getArgumentTypes((String)visitor.descriptor);
            for (int i = 0; i < argumentTypes.length; ++i) {
                Type requiredType = visitor.parameterAnnotations[i] != null && visitor.parameterAnnotations[i].isProgramCounter ? Type.LONG_TYPE : Type.INT_TYPE;
                if (Objects.equals(argumentTypes[i], requiredType)) continue;
                throw new IllegalArgumentException(String.format("Instruction definition [%s] parameter [%d] of type [%s], requires [%s].", visitor.name, i, argumentTypes[i].getClassName(), requiredType.getClassName()));
            }
            int argumentCount = visitor.parameterAnnotations.length;
            int fieldArgumentCount = 0;
            for (int i = 0; i < argumentCount; ++i) {
                if (visitor.parameterAnnotations[i] == null) {
                    throw new IllegalArgumentException(String.format("Instruction definition [%s] parameter [%d] has no usage annotation. Annotate arguments with the @Field annotations and instruction size parameters with the @InstructionSize annotation.", visitor.name, i + 1));
                }
                if (visitor.parameterAnnotations[i].argumentName == null) continue;
                ++fieldArgumentCount;
            }
            if (fieldArgumentCount != declaration.arguments.size()) {
                throw new IllegalArgumentException(String.format("Number of @Field parameters [%d] in instruction definition [%s] does not match number of expected arguments [%d] in instruction declaration of instruction [%s].", fieldArgumentCount, visitor.name, declaration.arguments.size(), declaration.displayName));
            }
            InstructionArgument[] arguments = new InstructionArgument[argumentCount];
            String[] argumentNames = new String[argumentCount];
            for (int i = 0; i < argumentCount; ++i) {
                ParameterAnnotation annotation = visitor.parameterAnnotations[i];
                if (annotation.argumentName != null) {
                    String argumentName = annotation.argumentName;
                    InstructionArgument argument = declaration.arguments.get(argumentName);
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Required argument [%s] for instruction definition [%s] not defined in instruction declaration.", argumentName, declaration.displayName));
                    }
                    arguments[i] = argument;
                    argumentNames[i] = argumentName;
                    continue;
                }
                if (annotation.isInstructionSize) {
                    arguments[i] = new ConstantInstructionArgument(declaration.size);
                    continue;
                }
                if (annotation.isProgramCounter) {
                    arguments[i] = new ProgramCounterInstructionArgument();
                    continue;
                }
                throw new AssertionError((Object)"Annotation info was generated but for neither @Field nor @InstructionSize annotation.");
            }
            InstructionDefinition definition = new InstructionDefinition(declaration.name, visitor.name, visitor.writesPC, returnsBoolean, visitor.thrownExceptions, arguments, argumentNames);
            definitions.put(declaration, definition);
        }
        return definitions;
    }

    private static final class InstructionFunctionVisitor
    extends MethodVisitor {
        private final Class<?> implementation;
        private final String name;
        private final String descriptor;
        private final String[] thrownExceptions;
        private final ParameterAnnotation[] parameterAnnotations;
        private final ArrayList<NonStaticMethodInvocation> nonStaticMethodInvocations = new ArrayList();
        private boolean isImplementation;
        private String instructionName;
        private boolean writesPC;

        public InstructionFunctionVisitor(Class<?> implementation, String name, String descriptor, String[] exceptions) {
            super(458752);
            this.implementation = implementation;
            this.name = name;
            this.descriptor = descriptor;
            this.thrownExceptions = exceptions;
            this.parameterAnnotations = new ParameterAnnotation[Type.getArgumentTypes((String)descriptor).length];
        }

        public AnnotationVisitor visitParameterAnnotation(final int parameter, String descriptor, boolean visible) {
            if (Objects.equals(descriptor, Type.getDescriptor(InstructionDefinition.Field.class))) {
                return new AnnotationVisitor(458752){

                    public void visit(String name, Object value) {
                        super.visit(name, value);
                        if (Objects.equals(name, "value")) {
                            String argumentName = (String)value;
                            if (argumentName == null) {
                                throw new IllegalStateException(String.format("Name of @Field annotation on parameter [%d] on instruction declaration [%s] is null.", parameter, name));
                            }
                            parameterAnnotations[parameter] = ParameterAnnotation.createField(argumentName);
                        }
                    }
                };
            }
            if (Objects.equals(descriptor, Type.getDescriptor(InstructionDefinition.InstructionSize.class))) {
                this.parameterAnnotations[parameter] = ParameterAnnotation.createInstructionSize();
                return null;
            }
            if (Objects.equals(descriptor, Type.getDescriptor(InstructionDefinition.ProgramCounter.class))) {
                this.parameterAnnotations[parameter] = ParameterAnnotation.createProgramCounter();
                return null;
            }
            return super.visitParameterAnnotation(parameter, descriptor, visible);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (Objects.equals(descriptor, Type.getDescriptor(InstructionDefinition.Instruction.class))) {
                this.isImplementation = true;
                return new AnnotationVisitor(458752){

                    public void visit(String name, Object value) {
                        super.visit(name, value);
                        if (Objects.equals(name, "value")) {
                            instructionName = (String)value;
                        }
                    }
                };
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            super.visitFieldInsn(opcode, owner, name, descriptor);
            if (!this.isImplementation) {
                return;
            }
            if (Objects.equals(owner, Type.getInternalName(this.implementation)) && Objects.equals(name, "pc")) {
                if (opcode == 180) {
                    throw new IllegalArgumentException(String.format("Instruction [%s] is reading from PC field. This value will be incorrect. Use the @ProgramCounter annotation to have the current PC value passed to the instruction.", this.name));
                }
                if (opcode == 181) {
                    this.writesPC = true;
                }
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (!this.isImplementation) {
                return;
            }
            if (opcode != 184) {
                this.nonStaticMethodInvocations.add(new NonStaticMethodInvocation(this.implementation, owner, name, descriptor));
            }
        }

        public void resolveInvokedMethods(ArrayList<NonStaticMethodInvocation> knownMethodInvocations) throws IOException {
            if (this.writesPC) {
                return;
            }
            for (NonStaticMethodInvocation invocation : this.nonStaticMethodInvocations) {
                if (!invocation.computeWritesPC(knownMethodInvocations)) continue;
                this.writesPC = true;
                break;
            }
        }

        public String toString() {
            return this.instructionName;
        }
    }

    private static final class ParameterAnnotation {
        public String argumentName;
        public boolean isInstructionSize;
        public boolean isProgramCounter;

        private ParameterAnnotation() {
        }

        public static ParameterAnnotation createField(String name) {
            ParameterAnnotation result = new ParameterAnnotation();
            result.argumentName = name;
            return result;
        }

        public static ParameterAnnotation createInstructionSize() {
            ParameterAnnotation result = new ParameterAnnotation();
            result.isInstructionSize = true;
            return result;
        }

        public static ParameterAnnotation createProgramCounter() {
            ParameterAnnotation result = new ParameterAnnotation();
            result.isProgramCounter = true;
            return result;
        }
    }

    private static final class NonStaticMethodInvocation {
        private final Class<?> implementation;
        private final String owner;
        private final String name;
        private final String descriptor;
        private final ArrayList<NonStaticMethodInvocation> invocations = new ArrayList();
        private boolean hasResolvedInvocations;
        private boolean writesPC;
        private boolean hasComputedWritesPC;

        private NonStaticMethodInvocation(Class<?> implementation, String owner, String name, String descriptor) {
            this.implementation = implementation;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonStaticMethodInvocation that = (NonStaticMethodInvocation)o;
            return this.owner.equals(that.owner) && this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.name, this.descriptor);
        }

        public boolean computeWritesPC(ArrayList<NonStaticMethodInvocation> knownMethodInvocations) throws IOException {
            NonStaticMethodInvocation invocation = NonStaticMethodInvocation.getUniqueInvocation(this, knownMethodInvocations);
            invocation.resolveInvocations(knownMethodInvocations);
            invocation.resolveWritesPC();
            return invocation.writesPC;
        }

        private static NonStaticMethodInvocation getUniqueInvocation(NonStaticMethodInvocation invocation, ArrayList<NonStaticMethodInvocation> knownMethodInvocations) {
            int index = knownMethodInvocations.indexOf(invocation);
            if (index >= 0) {
                return knownMethodInvocations.get(index);
            }
            knownMethodInvocations.add(invocation);
            return invocation;
        }

        private void resolveInvocations(final ArrayList<NonStaticMethodInvocation> knownMethodInvocations) throws IOException {
            if (this.hasResolvedInvocations) {
                return;
            }
            String ownerClassName = Type.getObjectType((String)this.owner).getClassName();
            if (ownerClassName.startsWith("java.")) {
                this.hasResolvedInvocations = true;
                return;
            }
            try (InputStream stream = this.implementation.getClassLoader().getResourceAsStream(ownerClassName.replace('.', '/') + ".class");){
                if (stream == null) {
                    this.hasResolvedInvocations = true;
                    LOGGER.warn("Failed loading class for type [{}] for analysis, skipping it.", (Object)ownerClassName);
                    return;
                }
                ClassReader reader = new ClassReader(stream);
                reader.accept(new ClassVisitor(458752){

                    public MethodVisitor visitMethod(int access, final String methodName, String methodDescriptor, String signature, String[] exceptions) {
                        if (methodName.equals(name) && methodDescriptor.equals(descriptor)) {
                            return new MethodVisitor(458752){

                                public void visitMethodInsn(int opcode, String invokedMethodOwner, String invokedMethodName, String invokedMethodDescriptor, boolean isInterface) {
                                    super.visitMethodInsn(opcode, invokedMethodOwner, invokedMethodName, invokedMethodDescriptor, isInterface);
                                    if (opcode != 184) {
                                        NonStaticMethodInvocation invocation = new NonStaticMethodInvocation(implementation, invokedMethodOwner, invokedMethodName, invokedMethodDescriptor);
                                        invocations.add(NonStaticMethodInvocation.getUniqueInvocation(invocation, knownMethodInvocations));
                                    }
                                }

                                public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                                    super.visitFieldInsn(opcode, owner, name, descriptor);
                                    if (Objects.equals(owner, Type.getInternalName(implementation)) && Objects.equals(name, "pc")) {
                                        if (opcode == 180) {
                                            throw new IllegalArgumentException(String.format("Method [%s] which is invoked by an instruction is reading from PC field. This value will be incorrect. Use the @ProgramCounter annotation to have the current PC value passed to the instruction and pass it along.", methodName));
                                        }
                                        if (opcode == 181) {
                                            writesPC = true;
                                        }
                                    }
                                }
                            };
                        }
                        return super.visitMethod(access, methodName, methodDescriptor, signature, exceptions);
                    }
                }, 0);
            }
            this.hasResolvedInvocations = true;
            for (NonStaticMethodInvocation invocation : this.invocations) {
                invocation.resolveInvocations(knownMethodInvocations);
            }
        }

        private void resolveWritesPC() {
            if (this.hasComputedWritesPC) {
                return;
            }
            this.propagateWrites(new HashSet<NonStaticMethodInvocation>());
            this.hasComputedWritesPC = true;
        }

        private boolean propagateWrites(HashSet<NonStaticMethodInvocation> seen) {
            boolean didAnyChange;
            if (this.writesPC) {
                return false;
            }
            do {
                didAnyChange = false;
                for (NonStaticMethodInvocation invocation : this.invocations) {
                    if (!seen.addAll(this.invocations)) continue;
                    boolean didChange = invocation.propagateWrites(seen);
                    didAnyChange = didAnyChange || didChange;
                }
            } while (didAnyChange);
            for (NonStaticMethodInvocation invocation : this.invocations) {
                this.writesPC = this.writesPC || invocation.writesPC;
            }
            return this.writesPC;
        }

        public String toString() {
            return this.name;
        }
    }
}

