/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.fs;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import li.cil.sedna.fs.DirectoryEntry;
import li.cil.sedna.fs.FileHandle;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.FileSystemStats;
import li.cil.sedna.fs.FileType;
import li.cil.sedna.fs.Path;

public final class ZipStreamFileSystem
implements FileSystem {
    private final ZipNode root = new ZipNode();
    private final long totalSize;
    private final int totalFileCount;

    public ZipStreamFileSystem(InputStream stream) throws IOException {
        ZipEntry entry;
        ZipInputStream zipStream = new ZipInputStream(stream);
        HashMap<ZipNode, ZipNode> parents = new HashMap<ZipNode, ZipNode>();
        ArrayList<ZipNode> nodes = new ArrayList<ZipNode>();
        nodes.add(this.root);
        long size = 0L;
        int fileCount = 0;
        while ((entry = zipStream.getNextEntry()) != null) {
            String[] parts = entry.getName().split("/");
            ZipNode current = this.root;
            for (int i = 0; i < parts.length && current != null; ++i) {
                if (".".equals(parts[i])) continue;
                if ("..".equals(parts[i])) {
                    current = (ZipNode)parents.get(current);
                    continue;
                }
                ZipNode child = current.children.computeIfAbsent(parts[i], name -> {
                    ZipNode node = new ZipNode();
                    nodes.add(node);
                    return node;
                });
                current.children.put(parts[i], child);
                parents.put(child, current);
                current = child;
            }
            if (current == null) continue;
            current.data = this.readEntryData(zipStream);
            current.attributes = new ZipNodeFileAttributes(entry, current.data.length);
            size += current.attributes.size();
            if (current.isDirectory()) continue;
            ++fileCount;
        }
        this.totalFileCount = fileCount;
        this.totalSize = size;
        nodes.forEach(ZipNode::buildEntries);
    }

    private byte[] readEntryData(ZipInputStream zipStream) throws IOException {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while (zipStream.available() > 0) {
            int count = zipStream.read(buffer);
            if (count <= 0) continue;
            dataStream.write(buffer, 0, count);
        }
        return dataStream.toByteArray();
    }

    @Override
    public FileSystemStats statfs() {
        FileSystemStats result = new FileSystemStats();
        result.blockCount = this.totalSize / (long)result.blockSize + 1L;
        result.fileCount = this.totalFileCount;
        return result;
    }

    @Override
    public long getUniqueId(Path path) throws IOException {
        return this.getNodeOrThrow(path).hashCode();
    }

    @Override
    public boolean exists(Path path) {
        return this.getNode(path) != null;
    }

    @Override
    public boolean isDirectory(Path path) {
        ZipNode node = this.getNode(path);
        return node != null && node.isDirectory();
    }

    @Override
    public boolean isWritable(Path path) {
        return false;
    }

    @Override
    public boolean isReadable(Path path) {
        return true;
    }

    @Override
    public boolean isExecutable(Path path) {
        return true;
    }

    @Override
    public BasicFileAttributes getAttributes(Path path) throws IOException {
        final ZipNode node = this.getNodeOrThrow(path);
        if (node.attributes != null) {
            return node.attributes;
        }
        return new BasicFileAttributes(){

            @Override
            @Nullable
            public FileTime lastModifiedTime() {
                return null;
            }

            @Override
            @Nullable
            public FileTime lastAccessTime() {
                return null;
            }

            @Override
            @Nullable
            public FileTime creationTime() {
                return null;
            }

            @Override
            public boolean isRegularFile() {
                return false;
            }

            @Override
            public boolean isDirectory() {
                return true;
            }

            @Override
            public boolean isSymbolicLink() {
                return false;
            }

            @Override
            public boolean isOther() {
                return false;
            }

            @Override
            public long size() {
                return 0L;
            }

            @Override
            public Object fileKey() {
                return node;
            }
        };
    }

    @Override
    public void mkdir(Path path) throws IOException {
        throw new IOException();
    }

    @Override
    public FileHandle open(Path path, int flags) throws IOException {
        if ((flags & 2) != 0) {
            throw new IOException();
        }
        final ZipNode node = this.getNodeOrThrow(path);
        if (node.isDirectory()) {
            return new FileHandle(){

                @Override
                public int read(long offset, ByteBuffer buffer) throws IOException {
                    throw new IOException();
                }

                @Override
                public int write(long offset, ByteBuffer buffer) throws IOException {
                    throw new IOException();
                }

                @Override
                public List<DirectoryEntry> readdir() {
                    return node.entries;
                }

                @Override
                public void close() {
                }
            };
        }
        final byte[] data = node.data;
        return new FileHandle(){

            @Override
            public int read(long offset, ByteBuffer buffer) throws IOException {
                if (offset < 0L || offset > (long)data.length) {
                    throw new IOException();
                }
                int count = Math.min(buffer.remaining(), (int)Math.min(Integer.MAX_VALUE, (long)data.length - offset));
                buffer.put(data, (int)offset, count);
                return count;
            }

            @Override
            public int write(long offset, ByteBuffer buffer) throws IOException {
                throw new IOException();
            }

            @Override
            public List<DirectoryEntry> readdir() throws IOException {
                throw new IOException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public FileHandle create(Path path, int flags) throws IOException {
        throw new IOException();
    }

    @Override
    public void unlink(Path path) throws IOException {
        throw new IOException();
    }

    @Override
    public void rename(Path oldpath, Path newpath) throws IOException {
        throw new IOException();
    }

    @Nullable
    private ZipNode getNode(Path path) {
        ZipNode node = this.root;
        for (String part : path.getParts()) {
            ZipNode child = node.children.get(part);
            if (child == null) {
                return null;
            }
            node = child;
        }
        return node;
    }

    private ZipNode getNodeOrThrow(Path path) throws IOException {
        ZipNode node = this.root;
        for (String part : path.getParts()) {
            ZipNode child = node.children.get(part);
            if (child == null) {
                throw new FileNotFoundException();
            }
            node = child;
        }
        return node;
    }

    private static final class ZipNode {
        public ZipNodeFileAttributes attributes;
        public byte[] data;
        public LinkedHashMap<String, ZipNode> children = new LinkedHashMap();
        public ArrayList<DirectoryEntry> entries = new ArrayList();

        private ZipNode() {
        }

        private void buildEntries() {
            this.children.forEach((name, child) -> {
                DirectoryEntry directoryEntry = new DirectoryEntry();
                directoryEntry.name = name;
                boolean childIsDirectory = child.attributes == null || child.attributes.isDirectory();
                directoryEntry.type = childIsDirectory ? FileType.DIRECTORY : FileType.FILE;
                this.entries.add(directoryEntry);
            });
        }

        public boolean isDirectory() {
            return this.attributes == null || this.attributes.isDirectory();
        }
    }

    private static final class ZipNodeFileAttributes
    implements BasicFileAttributes {
        private final FileTime lastModifiedTime;
        private final FileTime lastAccessTime;
        private final FileTime creationTime;
        private final boolean isDirectory;
        private final long size;

        public ZipNodeFileAttributes(ZipEntry entry, long size) {
            this.lastModifiedTime = entry.getLastModifiedTime();
            this.lastAccessTime = entry.getLastAccessTime();
            this.creationTime = entry.getCreationTime();
            this.isDirectory = entry.isDirectory();
            this.size = size;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public FileTime creationTime() {
            return this.creationTime;
        }

        @Override
        public boolean isRegularFile() {
            return !this.isDirectory;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public Object fileKey() {
            return this;
        }
    }
}

