/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import li.cil.sedna.fs.DirectoryEntry;
import li.cil.sedna.fs.FileHandle;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.FileSystemStats;
import li.cil.sedna.fs.FileType;
import li.cil.sedna.fs.Path;
import org.apache.commons.io.IOUtils;

public final class ZipFileSystem
implements FileSystem {
    private final ZipFile zipFile;
    private final ZipNode root = new ZipNode();

    public ZipFileSystem(ZipFile zipFile) {
        this.zipFile = zipFile;
        this.constructTree();
    }

    private void constructTree() {
        HashMap<ZipNode, ZipNode> parents = new HashMap<ZipNode, ZipNode>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String[] parts = entry.getName().split("/");
            ZipNode current = this.root;
            for (int i = 0; i < parts.length && current != null; ++i) {
                if (".".equals(parts[i])) continue;
                if ("..".equals(parts[i])) {
                    current = (ZipNode)parents.get(current);
                    continue;
                }
                ZipNode child = current.children.computeIfAbsent(parts[i], name -> new ZipNode());
                current.children.put(parts[i], child);
                parents.put(child, current);
                current = child;
            }
            if (current == null) continue;
            current.entry = entry;
        }
    }

    @Override
    public FileSystemStats statfs() {
        FileSystemStats result = new FileSystemStats();
        int size = this.zipFile.size();
        result.blockCount = size / result.blockSize + 1;
        return result;
    }

    @Override
    public long getUniqueId(Path path) throws IOException {
        return this.getNodeOrThrow(path).hashCode();
    }

    @Override
    public boolean exists(Path path) {
        return this.getNode(path) != null;
    }

    @Override
    public boolean isDirectory(Path path) {
        ZipNode node = this.getNode(path);
        return node != null && (node.entry == null || node.entry.isDirectory());
    }

    @Override
    public boolean isWritable(Path path) {
        return false;
    }

    @Override
    public boolean isReadable(Path path) {
        return true;
    }

    @Override
    public boolean isExecutable(Path path) {
        return true;
    }

    @Override
    public BasicFileAttributes getAttributes(Path path) throws IOException {
        final ZipNode node = this.getNodeOrThrow(path);
        if (node.entry != null) {
            final ZipEntry entry = node.entry;
            return new BasicFileAttributes(){

                @Override
                public FileTime lastModifiedTime() {
                    return entry.getLastModifiedTime();
                }

                @Override
                public FileTime lastAccessTime() {
                    return entry.getLastAccessTime();
                }

                @Override
                public FileTime creationTime() {
                    return entry.getCreationTime();
                }

                @Override
                public boolean isRegularFile() {
                    return !entry.isDirectory();
                }

                @Override
                public boolean isDirectory() {
                    return entry.isDirectory();
                }

                @Override
                public boolean isSymbolicLink() {
                    return false;
                }

                @Override
                public boolean isOther() {
                    return false;
                }

                @Override
                public long size() {
                    return entry.getSize();
                }

                @Override
                public Object fileKey() {
                    return node;
                }
            };
        }
        return new BasicFileAttributes(){

            @Override
            public FileTime lastModifiedTime() {
                return null;
            }

            @Override
            public FileTime lastAccessTime() {
                return null;
            }

            @Override
            public FileTime creationTime() {
                return null;
            }

            @Override
            public boolean isRegularFile() {
                return false;
            }

            @Override
            public boolean isDirectory() {
                return true;
            }

            @Override
            public boolean isSymbolicLink() {
                return false;
            }

            @Override
            public boolean isOther() {
                return false;
            }

            @Override
            public long size() {
                return 0L;
            }

            @Override
            public Object fileKey() {
                return node;
            }
        };
    }

    @Override
    public void mkdir(Path path) throws IOException {
        throw new IOException();
    }

    @Override
    public FileHandle open(Path path, int flags) throws IOException {
        if ((flags & 2) != 0) {
            throw new IOException();
        }
        ZipNode node = this.getNodeOrThrow(path);
        if (node.entry == null || node.entry.isDirectory()) {
            final ArrayList entries = new ArrayList();
            node.children.forEach((name, child) -> {
                DirectoryEntry directoryEntry = new DirectoryEntry();
                directoryEntry.name = name;
                boolean childIsDirectory = child.entry == null || child.entry.isDirectory();
                directoryEntry.type = childIsDirectory ? FileType.DIRECTORY : FileType.FILE;
                entries.add(directoryEntry);
            });
            return new FileHandle(){

                @Override
                public int read(long offset, ByteBuffer buffer) throws IOException {
                    throw new IOException();
                }

                @Override
                public int write(long offset, ByteBuffer buffer) throws IOException {
                    throw new IOException();
                }

                @Override
                public List<DirectoryEntry> readdir() {
                    return entries;
                }

                @Override
                public void close() {
                }
            };
        }
        final InputStream stream = this.zipFile.getInputStream(node.entry);
        final ByteBuffer data = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)stream));
        stream.close();
        return new FileHandle(){

            @Override
            public int read(long offset, ByteBuffer buffer) throws IOException {
                if (offset < 0L || offset > (long)data.capacity()) {
                    throw new IOException();
                }
                data.position((int)offset);
                int count = Math.min(buffer.remaining(), data.capacity() - data.position());
                data.limit(data.position() + count);
                buffer.put(data);
                return count;
            }

            @Override
            public int write(long offset, ByteBuffer buffer) throws IOException {
                throw new IOException();
            }

            @Override
            public List<DirectoryEntry> readdir() throws IOException {
                throw new IOException();
            }

            @Override
            public void close() throws IOException {
                stream.close();
            }
        };
    }

    @Override
    public FileHandle create(Path path, int flags) throws IOException {
        throw new IOException();
    }

    @Override
    public void unlink(Path path) throws IOException {
        throw new IOException();
    }

    @Override
    public void rename(Path oldPath, Path newPath) throws IOException {
        throw new IOException();
    }

    @Nullable
    private ZipNode getNode(Path path) {
        ZipNode node = this.root;
        for (String part : path.getParts()) {
            ZipNode child = node.children.get(part);
            if (child == null) {
                return null;
            }
            node = child;
        }
        return node;
    }

    private ZipNode getNodeOrThrow(Path path) throws IOException {
        ZipNode node = this.getNode(path);
        if (node == null) {
            throw new FileNotFoundException();
        }
        return node;
    }

    private static final class ZipNode {
        public ZipEntry entry;
        public LinkedHashMap<String, ZipNode> children = new LinkedHashMap();

        private ZipNode() {
        }
    }
}

