/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree.provider;

import java.util.Optional;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryMap;

public class MemoryMappedDeviceProvider
implements DeviceTreeProvider {
    @Override
    public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
        Optional<MappedMemoryRange> range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        return range.map(r -> root.getChild(deviceName, r.address()));
    }

    @Override
    public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
        MemoryMappedDevice mappedDevice = (MemoryMappedDevice)device;
        Optional<MappedMemoryRange> range = memoryMap.getMemoryRange(mappedDevice);
        range.ifPresent(r -> node.addProp("reg", r.address() & 0xFFFFFFFFL, (long)r.size() & 0xFFFFFFFFL));
    }
}

