/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FlattenedDeviceTree {
    private static final int FDT_MAGIC = -804389139;
    private static final int FDT_VERSION = 17;
    private static final int FDT_LAST_COMP_VERSION = 16;
    private static final int FDT_BEGIN_NODE = 1;
    private static final int FDT_END_NODE = 2;
    private static final int FDT_PROP = 3;
    private static final int FDT_NOP = 4;
    private static final int FDT_END = 9;
    private static final int FDT_HEADER_SIZE = 40;
    private final List<String> names = new ArrayList<String>();
    private final IntList nameOffsets = new IntArrayList();
    private final ByteArrayOutputStream structureBlock = new ByteArrayOutputStream();
    private final DataOutputStream structureBlockWriter = new DataOutputStream(this.structureBlock);
    private int openStructureNodes = 0;

    public void beginNode(String name) {
        try {
            this.structureBlockWriter.writeInt(1);
            this.structureBlockWriter.writeBytes(name);
            this.structureBlockWriter.writeByte(0);
            this.pad(this.structureBlockWriter, 4);
            ++this.openStructureNodes;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void endNode() {
        try {
            this.structureBlockWriter.writeInt(2);
            --this.openStructureNodes;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void property(String name, Object ... values) {
        try {
            int valuesByteLength = 0;
            for (Object value : values) {
                if (value instanceof String) {
                    valuesByteLength += ((String)value).length() + 1;
                    continue;
                }
                if (value instanceof Integer) {
                    valuesByteLength += 4;
                    continue;
                }
                if (value instanceof Long) {
                    valuesByteLength += 8;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            this.structureBlockWriter.writeInt(3);
            this.structureBlockWriter.writeInt(valuesByteLength);
            this.structureBlockWriter.writeInt(this.getPropertyNameOffset(name));
            for (Object value : values) {
                if (value instanceof String) {
                    this.structureBlockWriter.writeBytes((String)value);
                    this.structureBlockWriter.writeByte(0);
                    continue;
                }
                if (value instanceof Integer) {
                    this.structureBlockWriter.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    this.structureBlockWriter.writeInt((int)((Long)value >>> 32));
                    this.structureBlockWriter.writeInt((int)((Long)value).longValue());
                    continue;
                }
                throw new AssertionError();
            }
            this.pad(this.structureBlockWriter, 4);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] toDTB() {
        if (this.openStructureNodes != 0) {
            throw new IllegalStateException("Unbalanced nodes.");
        }
        try {
            ByteArrayOutputStream fdt = new ByteArrayOutputStream();
            DataOutputStream fdtWriter = new DataOutputStream(fdt);
            int pos = 40;
            int headerPadding = this.paddingTo(40, 8);
            int memoryReservationBlockOffset = pos += headerPadding;
            int memoryReservationBlockLength = 16;
            int structureBlockOffset = pos += 16;
            int structureBlockLength = this.structureBlockWriter.size() + 4;
            int stringsBlockOffset = pos += structureBlockLength;
            int stringsBlockLength = this.stringsBlockLength();
            fdt_header header = new fdt_header();
            header.boot_cpuid_phys = 0;
            header.totalsize = pos += stringsBlockLength;
            header.size_dt_strings = stringsBlockLength;
            header.size_dt_struct = structureBlockLength;
            header.off_dt_struct = structureBlockOffset;
            header.off_dt_strings = stringsBlockOffset;
            header.off_mem_rsvmap = memoryReservationBlockOffset;
            header.write(fdtWriter);
            this.pad(fdtWriter, 8);
            fdtWriter.writeLong(0L);
            fdtWriter.writeLong(0L);
            fdtWriter.write(this.structureBlock.toByteArray());
            fdtWriter.writeInt(9);
            for (String name : this.names) {
                fdtWriter.writeBytes(name);
                fdtWriter.writeByte(0);
            }
            return fdt.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void pad(DataOutputStream output, int alignment) throws IOException {
        int padding = this.paddingTo(output.size(), alignment);
        for (int i = 0; i < padding; ++i) {
            output.writeByte(0);
        }
    }

    private int paddingTo(int size, int alignment) {
        int mask = alignment - 1;
        if ((size & mask) == 0) {
            return 0;
        }
        return (size & ~mask) + alignment - size;
    }

    private int getPropertyNameOffset(String name) {
        int index = this.names.indexOf(name);
        if (index >= 0) {
            return this.nameOffsets.getInt(index);
        }
        if (this.names.size() > 0) {
            int nameOffset = this.stringsBlockLength();
            this.names.add(name);
            this.nameOffsets.add(nameOffset);
            return nameOffset;
        }
        this.names.add(name);
        this.nameOffsets.add(0);
        return 0;
    }

    private int stringsBlockLength() {
        if (this.nameOffsets.size() == 0) {
            return 0;
        }
        int lastNameIndex = this.names.size() - 1;
        int lastNameLength = this.names.get(lastNameIndex).length();
        int lastNameOffset = this.nameOffsets.getInt(lastNameIndex);
        return lastNameOffset + lastNameLength + 1;
    }

    private static final class fdt_header {
        public final int magic = -804389139;
        public int totalsize;
        public int off_dt_struct;
        public int off_dt_strings;
        public int off_mem_rsvmap;
        public final int version = 17;
        public final int last_comp_version = 16;
        public int boot_cpuid_phys;
        public int size_dt_strings;
        public int size_dt_struct;

        private fdt_header() {
        }

        public void write(DataOutput output) throws IOException {
            output.writeInt(-804389139);
            output.writeInt(this.totalsize);
            output.writeInt(this.off_dt_struct);
            output.writeInt(this.off_dt_strings);
            output.writeInt(this.off_mem_rsvmap);
            output.writeInt(17);
            output.writeInt(16);
            output.writeInt(this.boot_cpuid_phys);
            output.writeInt(this.size_dt_strings);
            output.writeInt(this.size_dt_struct);
        }
    }
}

