/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.devicetree.DeviceTreeImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DeviceTreeRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<? extends Device>, DeviceTreeProvider> PROVIDERS = new HashMap<Class<? extends Device>, DeviceTreeProvider>();
    private static final Map<Class<? extends Device>, DeviceTreeProvider> PROVIDER_CACHE = new HashMap<Class<? extends Device>, DeviceTreeProvider>();

    public static void putProvider(Class<? extends Device> type, DeviceTreeProvider provider) {
        PROVIDERS.put(type, provider);
        PROVIDER_CACHE.clear();
    }

    private static void visitBaseTypes(@Nullable Class<?> type, Consumer<Class<?>> visitor) {
        Class<?>[] interfaces;
        if (type == null) {
            return;
        }
        visitor.accept(type);
        DeviceTreeRegistry.visitBaseTypes(type.getSuperclass(), visitor);
        for (Class<?> iface : interfaces = type.getInterfaces()) {
            visitor.accept(iface);
            DeviceTreeRegistry.visitBaseTypes(iface, visitor);
        }
    }

    @Nullable
    public static DeviceTreeProvider getProvider(Device device) {
        Class<?> deviceClass = device.getClass();
        if (PROVIDER_CACHE.containsKey(deviceClass)) {
            return PROVIDER_CACHE.get(deviceClass);
        }
        final ArrayList relevant = new ArrayList();
        HashSet seen = new HashSet();
        DeviceTreeRegistry.visitBaseTypes(deviceClass, c -> {
            if (seen.add(c) && PROVIDERS.containsKey(c)) {
                relevant.add(PROVIDERS.get(c));
            }
        });
        if (relevant.size() == 0) {
            return null;
        }
        if (relevant.size() == 1) {
            return (DeviceTreeProvider)relevant.get(0);
        }
        Collections.reverse(relevant);
        return new DeviceTreeProvider(){

            @Override
            public Optional<String> getName(Device device) {
                for (int i = relevant.size() - 1; i >= 0; --i) {
                    Optional<String> name = ((DeviceTreeProvider)relevant.get(i)).getName(device);
                    if (!name.isPresent()) continue;
                    return name;
                }
                return Optional.empty();
            }

            @Override
            public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
                for (int i = relevant.size() - 1; i >= 0; --i) {
                    Optional<DeviceTree> node = ((DeviceTreeProvider)relevant.get(i)).createNode(root, memoryMap, device, deviceName);
                    if (!node.isPresent()) continue;
                    return node;
                }
                return Optional.empty();
            }

            @Override
            public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
                for (DeviceTreeProvider provider : relevant) {
                    provider.visit(node, memoryMap, device);
                }
            }
        };
    }

    @Nullable
    public static DeviceTree visit(DeviceTree root, MemoryMap memoryMap, Device device) {
        DeviceTreeProvider provider = DeviceTreeRegistry.getProvider(device);
        if (provider == null) {
            LOGGER.warn("No provider for device [{}].", (Object)device);
            return null;
        }
        Optional<String> name = provider.getName(device);
        if (name.isEmpty()) {
            LOGGER.warn("Failed obtaining name for device [{}].", (Object)device);
            return null;
        }
        Optional<DeviceTree> node = provider.createNode(root, memoryMap, device, name.get());
        if (node.isEmpty()) {
            LOGGER.warn("Failed obtaining node for device [{}].", (Object)device);
            return null;
        }
        provider.visit(node.get(), memoryMap, device);
        return node.get();
    }

    public static DeviceTree create(MemoryMap mmu) {
        return new DeviceTreeImpl(mmu);
    }
}

