/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.virtio.AbstractVirtIODevice;
import li.cil.sedna.device.virtio.DescriptorChain;
import li.cil.sedna.device.virtio.VirtIODeviceException;
import li.cil.sedna.device.virtio.VirtIODeviceSpec;

public final class VirtIONetworkDevice
extends AbstractVirtIODevice {
    private static final long VIRTIO_NET_F_CSUM = 1L;
    private static final long VIRTIO_NET_F_GUEST_CSUM = 2L;
    private static final long VIRTIO_NET_F_CTRL_GUEST_OFFLOADS = 4L;
    private static final long VIRTIO_NET_F_MTU = 8L;
    private static final long VIRTIO_NET_F_MAC = 32L;
    private static final long VIRTIO_NET_F_GUEST_TSO4 = 128L;
    private static final long VIRTIO_NET_F_GUEST_TSO6 = 256L;
    private static final long VIRTIO_NET_F_GUEST_ECN = 512L;
    private static final long VIRTIO_NET_F_GUEST_UFO = 1024L;
    private static final long VIRTIO_NET_F_HOST_TSO4 = 2048L;
    private static final long VIRTIO_NET_F_HOST_TSO6 = 4096L;
    private static final long VIRTIO_NET_F_HOST_ECN = 8192L;
    private static final long VIRTIO_NET_F_HOST_UFO = 16384L;
    private static final long VIRTIO_NET_F_MRG_RXBUF = 32768L;
    private static final long VIRTIO_NET_F_STATUS = 65536L;
    private static final long VIRTIO_NET_F_CTRL_VQ = 131072L;
    private static final long VIRTIO_NET_F_CTRL_RX = 262144L;
    private static final long VIRTIO_NET_F_CTRL_VLAN = 524288L;
    private static final long VIRTIO_NET_F_GUEST_ANNOUNCE = 0x200000L;
    private static final long VIRTIO_NET_F_MQ = 0x400000L;
    private static final long VIRTIO_NET_F_CTRL_MAC_ADDR = 0x800000L;
    private static final long VIRTIO_NET_F_RSC_EXT = 0x2000000000000000L;
    private static final long VIRTIO_NET_F_STANDBY = 0x4000000000000000L;
    private static final short VIRTIO_NET_S_LINK_UP = 1;
    private static final short VIRTIO_NET_S_ANNOUNCE = 2;
    private static final int VIRTIO_NETWORK_CFG_MAC_OFFSET = 0;
    private static final int VIRTIO_NETWORK_CFG_STATUS_OFFSET = 6;
    private static final int VIRTIO_NETWORK_CFG_MAX_VIRTQUEUE_PAIRS_OFFSET = 8;
    private static final int VIRTIO_NETWORK_CFG_MTU_OFFSET = 10;
    private static final byte VIRTIO_NET_CTRL_RX = 0;
    private static final byte VIRTIO_NET_CTRL_MAC = 1;
    private static final byte VIRTIO_NET_CTRL_VLAN = 2;
    private static final byte VIRTIO_NET_CTRL_ANNOUNCE = 3;
    private static final byte VIRTIO_NET_CTRL_RX_PROMISC = 0;
    private static final byte VIRTIO_NET_CTRL_RX_ALLMULTI = 1;
    private static final byte VIRTIO_NET_CTRL_RX_ALLUNI = 2;
    private static final byte VIRTIO_NET_CTRL_RX_NOMULTI = 3;
    private static final byte VIRTIO_NET_CTRL_RX_NOUNI = 4;
    private static final byte VIRTIO_NET_CTRL_RX_NOBCAST = 5;
    private static final byte VIRTIO_NET_CTRL_MAC_TABLE_SET = 0;
    private static final byte VIRTIO_NET_CTRL_MAC_ADDR_SET = 1;
    private static final byte VIRTIO_NET_CTRL_VLAN_ADD = 0;
    private static final byte VIRTIO_NET_CTRL_VLAN_DEL = 1;
    private static final byte VIRTIO_NET_CTRL_ANNOUNCE_ACK = 0;
    private static final byte VIRTIO_NET_OK = 0;
    private static final byte VIRTIO_NET_ERR = 1;
    public static final int VIRTIO_NET_HDR_F_NONE = 0;
    public static final int VIRTIO_NET_HDR_F_NEEDS_CSUM = 1;
    public static final int VIRTIO_NET_HDR_F_DATA_VALID = 2;
    public static final int VIRTIO_NET_HDR_F_RSC_INFO = 4;
    public static final int VIRTIO_NET_HDR_GSO_NONE = 0;
    public static final int VIRTIO_NET_HDR_GSO_TCPV4 = 1;
    public static final int VIRTIO_NET_HDR_GSO_UDP = 3;
    public static final int VIRTIO_NET_HDR_GSO_TCPV6 = 4;
    public static final int VIRTIO_NET_HDR_GSO_ECN = 128;
    private static final int HEADER_SIZE = 12;
    private static final int VIRTQ_RECEIVE = 0;
    private static final int VIRTQ_TRANSMIT = 1;
    private static final int VIRTQ_CONTROL = 2;
    @Serialized
    private byte[] mac = new byte[6];

    public VirtIONetworkDevice(MemoryMap memoryMap) {
        super(memoryMap, VirtIODeviceSpec.builder(1).features(32L).configSpaceSize(8).queueCount(2).build());
        this.mac[0] = 94;
        this.mac[1] = -48;
        int hash = this.hashCode();
        this.mac[2] = (byte)(hash >> 24 & 0xFF);
        this.mac[3] = (byte)(hash >> 16 & 0xFF);
        this.mac[4] = (byte)(hash >> 8 & 0xFF);
        this.mac[5] = (byte)(hash & 0xFF);
    }

    @Nullable
    public byte[] readEthernetFrame() {
        if (this.hasDeviceFailed()) {
            return null;
        }
        try {
            DescriptorChain transmit = this.validateReadOnlyDescriptorChain(1, null);
            if (transmit == null) {
                return null;
            }
            for (int i = 0; i < 12; ++i) {
                transmit.get();
            }
            byte[] packet = new byte[transmit.readableBytes()];
            transmit.get(packet, 0, packet.length);
            transmit.use();
            return packet;
        }
        catch (MemoryAccessException | VirtIODeviceException e) {
            this.error();
            return null;
        }
    }

    public void writeEthernetFrame(byte[] packet) {
        if (this.hasDeviceFailed()) {
            return;
        }
        try {
            DescriptorChain receive = this.validateWriteOnlyDescriptorChain(0, null);
            if (receive == null) {
                return;
            }
            for (int i = 0; i < 12; ++i) {
                receive.put((byte)0);
            }
            receive.put(packet, 0, packet.length);
            receive.use();
        }
        catch (MemoryAccessException | VirtIODeviceException e) {
            this.error();
        }
    }

    @Override
    protected void initializeConfig() {
        this.setConfigValue(0, this.mac);
    }

    @Override
    protected void handleFeaturesNegotiated() {
        this.setQueueNotifications(0, false);
        this.setQueueNotifications(1, false);
    }

    private boolean hasDeviceFailed() {
        return (this.getStatus() & 0x80) != 0;
    }
}

