/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

public final class VirtIODeviceSpec {
    private static final int MAX_CONFIG_SPACE_SIZE = 256;
    private static final int MAX_VIRTQUEUE_COUNT = 16;
    public final int deviceId;
    public final int vendorId;
    public final long features;
    public final int configSpaceSizeInBytes;
    public final int virtQueueCount;

    VirtIODeviceSpec(int deviceId, int vendorId, long features, int configSpaceSizeInBytes, int virtQueueCount) {
        if (configSpaceSizeInBytes < 0 || configSpaceSizeInBytes > 256) {
            throw new IndexOutOfBoundsException();
        }
        if (virtQueueCount < 0 || virtQueueCount > 16) {
            throw new IndexOutOfBoundsException();
        }
        this.deviceId = deviceId;
        this.vendorId = vendorId;
        this.features = features | 0x100000000L;
        this.configSpaceSizeInBytes = configSpaceSizeInBytes;
        this.virtQueueCount = virtQueueCount;
    }

    public static Builder builder(int deviceId) {
        return new Builder(deviceId);
    }

    public static final class Builder {
        private final int deviceId;
        private int vendorId = 65535;
        private long features;
        private int configSpaceSizeInBytes;
        private int virtQueueCount;

        public Builder vendorId(int value) {
            this.vendorId = value;
            return this;
        }

        public Builder features(long value) {
            this.features = value;
            return this;
        }

        public Builder configSpaceSize(int sizeInBytes) {
            if (sizeInBytes < 0 || sizeInBytes > 256) {
                throw new IndexOutOfBoundsException();
            }
            this.configSpaceSizeInBytes = sizeInBytes;
            return this;
        }

        public Builder queueCount(int value) {
            if (value < 0 || value > 16) {
                throw new IndexOutOfBoundsException();
            }
            this.virtQueueCount = value;
            return this;
        }

        public VirtIODeviceSpec build() {
            return new VirtIODeviceSpec(this.deviceId, this.vendorId, this.features, this.configSpaceSizeInBytes, this.virtQueueCount);
        }

        private Builder(int deviceId) {
            this.deviceId = deviceId;
        }
    }
}

