/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import it.unimi.dsi.fastutil.bytes.ByteArrayFIFOQueue;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.device.serial.SerialDevice;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.virtio.AbstractVirtIODevice;
import li.cil.sedna.device.virtio.DescriptorChain;
import li.cil.sedna.device.virtio.VirtIODeviceException;
import li.cil.sedna.device.virtio.VirtIODeviceSpec;

public final class VirtIOConsoleDevice
extends AbstractVirtIODevice
implements SerialDevice {
    private static final short DEFAULT_COLUMN_COUNT = 80;
    private static final short DEFAULT_ROW_COUNT = 25;
    private static final int BUFFER_SIZE = 4096;
    private static final long VIRTIO_CONSOLE_F_SIZE = 1L;
    private static final long VIRTIO_CONSOLE_F_MULTIPORT = 2L;
    private static final long VIRTIO_CONSOLE_F_EMERG_WRITE = 4L;
    private static final int VIRTIO_CONSOLE_DEVICE_READY = 0;
    private static final int VIRTIO_CONSOLE_DEVICE_ADD = 1;
    private static final int VIRTIO_CONSOLE_DEVICE_REMOVE = 2;
    private static final int VIRTIO_CONSOLE_PORT_READY = 3;
    private static final int VIRTIO_CONSOLE_CONSOLE_PORT = 4;
    private static final int VIRTIO_CONSOLE_RESIZE = 5;
    private static final int VIRTIO_CONSOLE_PORT_OPEN = 6;
    private static final int VIRTIO_CONSOLE_PORT_NAME = 7;
    private static final int VIRTIO_CONSOLE_CFG_COLS_OFFSET = 0;
    private static final int VIRTIO_CONSOLE_CFG_ROWS_OFFSET = 2;
    private static final int VIRTIO_CONSOLE_CFG_MAX_NR_PORTS_OFFSET = 4;
    private static final int VIRTIO_CONSOLE_CFG_EMERG_WR_OFFSET = 8;
    private static final int VIRTQ_RECEIVE = 0;
    private static final int VIRTQ_TRANSMIT = 1;
    private static final int VIRTQ_RECEIVE_CONTROL = 2;
    private static final int VIRTQ_TRANSMIT_CONTROL = 3;
    @Serialized
    private final ByteArrayFIFOQueue transmitBuffer = new ByteArrayFIFOQueue(4096);
    @Serialized
    private final ByteArrayFIFOQueue receiveBuffer = new ByteArrayFIFOQueue(4096);

    public VirtIOConsoleDevice(MemoryMap memoryMap) {
        super(memoryMap, VirtIODeviceSpec.builder(3).features(1L).queueCount(2).configSpaceSize(4).build());
    }

    @Override
    public int read() {
        if (this.hasDeviceFailed()) {
            return -1;
        }
        if (this.transmitBuffer.isEmpty()) {
            try {
                DescriptorChain transmit = this.validateReadOnlyDescriptorChain(1, null);
                if (transmit != null) {
                    while (transmit.readableBytes() > 0) {
                        this.transmitBuffer.enqueue(transmit.get());
                    }
                    transmit.use();
                }
            }
            catch (MemoryAccessException | VirtIODeviceException e) {
                this.error();
                return -1;
            }
        }
        if (this.transmitBuffer.isEmpty()) {
            return -1;
        }
        return this.transmitBuffer.dequeueByte() & 0xFF;
    }

    @Override
    public boolean canPutByte() {
        if (this.hasDeviceFailed()) {
            return false;
        }
        return this.receiveBuffer.size() < 4096;
    }

    @Override
    public void putByte(byte value) {
        if (this.hasDeviceFailed()) {
            return;
        }
        if (this.receiveBuffer.size() < 4096) {
            this.receiveBuffer.enqueue(value);
        }
        if (this.receiveBuffer.size() >= 4096) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this.hasDeviceFailed()) {
            return;
        }
        while (!this.receiveBuffer.isEmpty()) {
            try {
                DescriptorChain receive = this.validateWriteOnlyDescriptorChain(0, null);
                if (receive == null) {
                    return;
                }
                while (receive.writableBytes() > 0 && !this.receiveBuffer.isEmpty()) {
                    receive.put(this.receiveBuffer.dequeueByte());
                }
                receive.use();
            }
            catch (MemoryAccessException | VirtIODeviceException e) {
                this.error();
                return;
            }
        }
    }

    @Override
    protected void initializeConfig() {
        this.setConfigValue(0, (short)80);
        this.setConfigValue(2, (short)25);
    }

    @Override
    protected void storeConfig(int offset, long value, int sizeLog2) {
        if (offset == 8) {
            // empty if block
        }
    }

    @Override
    protected void handleFeaturesNegotiated() {
        this.setQueueNotifications(0, false);
        this.setQueueNotifications(1, false);
    }

    private boolean hasDeviceFailed() {
        return (this.getStatus() & 0x80) != 0;
    }
}

