/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.block.NullBlockDevice;
import li.cil.sedna.device.virtio.AbstractVirtIODevice;
import li.cil.sedna.device.virtio.DescriptorChain;
import li.cil.sedna.device.virtio.VirtIODeviceException;
import li.cil.sedna.device.virtio.VirtIODeviceSpec;
import li.cil.sedna.device.virtio.VirtqueueIterator;

public final class VirtIOBlockDevice
extends AbstractVirtIODevice
implements Steppable,
Closeable {
    private static final int VIRTIO_BLK_SECTOR_SIZE = 512;
    private static final int VIRTIO_BLK_F_SIZE_MAX = 2;
    private static final int VIRTIO_BLK_F_SEG_MAX = 4;
    private static final int VIRTIO_BLK_F_GEOMETRY = 16;
    private static final int VIRTIO_BLK_F_RO = 32;
    private static final int VIRTIO_BLK_F_BLK_SIZE = 64;
    private static final int VIRTIO_BLK_F_FLUSH = 512;
    private static final int VIRTIO_BLK_F_TOPOLOGY = 1024;
    private static final int VIRTIO_BLK_F_CONFIG_WCE = 2048;
    private static final int VIRTIO_BLK_F_DISCARD = 8192;
    private static final int VIRTIO_BLK_F_WRITE_ZEROES = 16384;
    private static final int VIRTIO_BLK_CFG_CAPACITY_OFFSET = 0;
    private static final int VIRTIO_BLK_CFG_CAPACITYH_OFFSET = 4;
    private static final int VIRTIO_BLK_CFG_SIZE_MAX_OFFSET = 8;
    private static final int VIRTIO_BLK_CFG_SEG_MAX_OFFSET = 12;
    private static final int VIRTIO_BLK_CFG_GEOMETRY_CYLINDERS_OFFSET = 16;
    private static final int VIRTIO_BLK_CFG_GEOMETRY_HEADS_OFFSET = 18;
    private static final int VIRTIO_BLK_CFG_GEOMETRY_SECTORS_OFFSET = 19;
    private static final int VIRTIO_BLK_CFG_BLK_SIZE_OFFSET = 20;
    private static final int VIRTIO_BLK_CFG_TOPOLOGY_PHYSICAL_BLOCK_EXP_OFFSET = 24;
    private static final int VIRTIO_BLK_CFG_TOPOLOGY_ALIGNMENT_OFFSET_OFFSET = 25;
    private static final int VIRTIO_BLK_CFG_TOPOLOGY_MIN_IO_SIZE_OFFSET = 26;
    private static final int VIRTIO_BLK_CFG_TOPOLOGY_OPT_IO_SIZE_OFFSET = 28;
    private static final int VIRTIO_BLK_CFG_WRITEBACK_OFFSET = 32;
    private static final int VIRTIO_BLK_CFG_MAX_DISCARD_SECTORS_OFFSET = 36;
    private static final int VIRTIO_BLK_CFG_MAX_DISCARD_SEG_OFFSET = 40;
    private static final int VIRTIO_BLK_CFG_DISCARD_SECTOR_ALIGNMENT_OFFSET = 44;
    private static final int VIRTIO_BLK_CFG_MAX_WRITE_ZEROES_SECTORS_OFFSET = 48;
    private static final int VIRTIO_BLK_CFG_MAX_WRITE_ZEROES_SEG_OFFSET = 52;
    private static final int VIRTIO_BLK_CFG_WRITE_ZEROES_MAY_UNMAP_OFFSET = 56;
    private static final int VIRTIO_BLK_T_IN = 0;
    private static final int VIRTIO_BLK_T_OUT = 1;
    private static final int VIRTIO_BLK_T_FLUSH = 4;
    private static final int VIRTIO_BLK_T_DISCARD = 11;
    private static final int VIRTIO_BLK_T_WRITE_ZEROES = 13;
    private static final int VIRTIO_BLK_S_OK = 0;
    private static final int VIRTIO_BLK_S_IOERR = 1;
    private static final int VIRTIO_BLK_S_UNSUPP = 2;
    private static final int VIRTQ_REQUEST = 0;
    private static final int MAX_SEGMENT_SIZE = 16384;
    private static final int MAX_SEGMENT_COUNT = 64;
    private static final int BYTES_PER_THOUSAND_CYCLES = 32;
    private static final ThreadLocal<ByteBuffer> REQUEST_HEADER_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN));
    private static final ThreadLocal<byte[]> COPY_BUFFER = ThreadLocal.withInitial(() -> new byte[65536]);
    private BlockDevice block;
    private int remainingByteProcessingQuota;
    @Serialized
    private boolean hasPendingRequest;

    public VirtIOBlockDevice(MemoryMap memoryMap, boolean readonly) {
        this(memoryMap, NullBlockDevice.get(readonly));
    }

    public VirtIOBlockDevice(MemoryMap memoryMap, BlockDevice block) {
        super(memoryMap, VirtIODeviceSpec.builder(2).configSpaceSize(56).queueCount(1).features((block.isReadonly() ? 32 : 0) | 0x200).build());
        this.block = block;
    }

    public void setBlock(BlockDevice block) throws IOException {
        BlockDevice oldBlock = this.block;
        this.block = block;
        this.notifyConfigChanged();
        if (oldBlock != null) {
            oldBlock.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.block.close();
    }

    @Override
    public void reset() {
        super.reset();
        this.hasPendingRequest = false;
    }

    @Override
    public void step(int cycles) {
        int byteQuota = Math.max(1, cycles * 32 / 1000);
        this.remainingByteProcessingQuota = this.remainingByteProcessingQuota <= 0 ? (this.remainingByteProcessingQuota += byteQuota) : byteQuota;
        if (!this.hasPendingRequest) {
            return;
        }
        if ((this.getStatus() & 0x80) != 0) {
            return;
        }
        try {
            int processedBytes;
            while (this.remainingByteProcessingQuota > 0 && (processedBytes = this.processRequest()) >= 0) {
                this.remainingByteProcessingQuota -= processedBytes;
            }
        }
        catch (Throwable e) {
            this.error();
        }
    }

    @Override
    protected int loadConfig(int offset, int sizeLog2) {
        switch (offset) {
            case 0: {
                return (int)(VirtIOBlockDevice.capacityToSectorCount(this.block.getCapacity()) & 0xFFFFFFFFL);
            }
            case 4: {
                return (int)(VirtIOBlockDevice.capacityToSectorCount(this.block.getCapacity()) >>> 32);
            }
            case 8: {
                return 16384;
            }
            case 12: {
                return 64;
            }
        }
        return super.loadConfig(offset, sizeLog2);
    }

    @Override
    protected void storeConfig(int offset, long value, int sizeLog2) {
    }

    @Override
    protected void handleQueueNotification(int queueIndex) {
        this.hasPendingRequest = true;
    }

    private int processRequest() throws VirtIODeviceException, MemoryAccessException {
        VirtqueueIterator queue = this.getQueueIterator(0);
        if (queue == null) {
            this.hasPendingRequest = false;
            return -1;
        }
        if (!queue.hasNext()) {
            this.hasPendingRequest = false;
            return -1;
        }
        DescriptorChain chain = queue.next();
        int processedBytes = chain.readableBytes() + chain.writableBytes();
        ByteBuffer header = VirtIOBlockDevice.getRequestHeaderBuffer();
        if (chain.readableBytes() < header.limit()) {
            throw new VirtIODeviceException();
        }
        chain.get(header);
        header.flip();
        int type = header.getInt();
        header.getInt();
        long sector = header.getLong();
        switch (type) {
            case 0: {
                if (chain.readableBytes() > 0) {
                    throw new VirtIODeviceException();
                }
                if ((chain.writableBytes() - 1) % 512 != 0) {
                    throw new VirtIODeviceException();
                }
                if (chain.writableBytes() > 0x100000) {
                    chain.skip(chain.writableBytes() - 1);
                    chain.put((byte)1);
                    break;
                }
                long offset = sector * 512L;
                boolean status = false;
                try {
                    int count;
                    int readCount;
                    InputStream stream = this.block.getInputStream(offset);
                    byte[] buffer = COPY_BUFFER.get();
                    int requestedReadCount = chain.writableBytes() - 1;
                    for (int totalReadCount = 0; totalReadCount < requestedReadCount && (readCount = stream.read(buffer, 0, count = Math.min(buffer.length, requestedReadCount - totalReadCount))) >= 0; totalReadCount += readCount) {
                        chain.put(buffer, 0, readCount);
                    }
                    chain.skip(chain.writableBytes() - 1);
                }
                catch (IOException | IllegalArgumentException e) {
                    chain.skip(chain.writableBytes() - 1);
                    status = true;
                }
                chain.put((byte)(status ? 1 : 0));
                break;
            }
            case 1: {
                if (chain.writableBytes() != 1) {
                    throw new VirtIODeviceException();
                }
                if (chain.readableBytes() % 512 != 0) {
                    throw new VirtIODeviceException();
                }
                if (chain.readableBytes() > 0x100000) {
                    chain.skip(chain.readableBytes());
                    chain.put((byte)1);
                    break;
                }
                long offset = sector * 512L;
                boolean status = false;
                try {
                    int count;
                    OutputStream stream = this.block.getOutputStream(offset);
                    byte[] buffer = COPY_BUFFER.get();
                    int requestedWriteCount = chain.readableBytes();
                    for (int totalWriteCount = 0; totalWriteCount < requestedWriteCount; totalWriteCount += count) {
                        count = Math.min(buffer.length, requestedWriteCount - totalWriteCount);
                        chain.get(buffer, 0, count);
                        stream.write(buffer, 0, count);
                    }
                }
                catch (IOException | IllegalArgumentException | ReadOnlyBufferException e) {
                    status = true;
                }
                chain.skip(chain.readableBytes());
                chain.put((byte)(status ? 1 : 0));
                break;
            }
            case 4: {
                if (chain.readableBytes() > 0) {
                    throw new VirtIODeviceException();
                }
                if (chain.writableBytes() != 1) {
                    throw new VirtIODeviceException();
                }
                this.block.flush();
                chain.put((byte)0);
                break;
            }
            default: {
                chain.skip(chain.readableBytes());
                chain.skip(chain.writableBytes() - 1);
                chain.put((byte)2);
            }
        }
        chain.use();
        return processedBytes;
    }

    private static long capacityToSectorCount(long capacity) {
        return capacity / 512L;
    }

    private static ByteBuffer getRequestHeaderBuffer() {
        return REQUEST_HEADER_BUFFER.get().clear();
    }
}

