/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.memory;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import li.cil.sedna.device.memory.ByteBufferMemory;

public final class FileMappedMemory
extends ByteBufferMemory {
    private final FileChannel channel;
    private int size;

    public FileMappedMemory(int size, File file) throws IOException {
        this(size, new RandomAccessFile(file, "rw"));
    }

    private FileMappedMemory(int size, RandomAccessFile file) throws IOException {
        this(size, file.getChannel());
    }

    private FileMappedMemory(int size, FileChannel channel) throws IOException {
        super(size, channel.map(FileChannel.MapMode.READ_WRITE, 0L, size));
        this.channel = channel;
    }

    @Override
    public void close() throws Exception {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.size = 0;
        super.close();
    }

    @Override
    public int getLength() {
        return this.size;
    }
}

