/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.device.BlockDevice;

public final class SparseBlockDevice
implements BlockDevice {
    private static final int DEFAULT_BLOCK_SIZE = 65536;
    private final BlockDevice lower;
    private final int blockSize;
    private final boolean readonly;
    @Serialized
    private final SparseBlockMap blocks;

    public SparseBlockDevice(BlockDevice lower) {
        this(lower, false, 65536);
    }

    public SparseBlockDevice(BlockDevice lower, boolean readonly) {
        this(lower, readonly, 65536);
    }

    public SparseBlockDevice(BlockDevice lower, boolean readonly, int blockSize) {
        if (lower.getCapacity() / (long)blockSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Lower BlockDevice is too large.");
        }
        this.lower = lower;
        this.blockSize = blockSize;
        this.readonly = readonly;
        int blockCount = Math.max(1, (int)(lower.getCapacity() / (long)blockSize));
        this.blocks = new SparseBlockMap(blockCount);
    }

    public int getBlockCount() {
        return this.blocks.size();
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public long getCapacity() {
        return this.lower.getCapacity();
    }

    @Override
    public InputStream getInputStream(long offset) {
        return new SparseInputStream(offset);
    }

    @Override
    public OutputStream getOutputStream(long offset) {
        if (this.isReadonly()) {
            throw new UnsupportedOperationException();
        }
        return new SparseOutputStream(offset);
    }

    private int offsetToBlockIndex(long offset) {
        return (int)(offset / (long)this.blockSize);
    }

    private int blockIndexToOffset(int index) {
        return index * this.blockSize;
    }

    public static final class SparseBlockMap
    extends Int2ObjectArrayMap<byte[]> {
        public SparseBlockMap(int capacity) {
            super(capacity);
        }
    }

    private final class SparseInputStream
    extends InputStream {
        private final InputStream lowerStream;
        private long offset;

        public SparseInputStream(long offset) {
            this.offset = offset;
            this.lowerStream = SparseBlockDevice.this.lower.getInputStream(offset);
        }

        @Override
        public int read() throws IOException {
            int readValue;
            if (this.offset >= SparseBlockDevice.this.getCapacity()) {
                return -1;
            }
            int blockIndex = SparseBlockDevice.this.offsetToBlockIndex(this.offset);
            byte[] block = (byte[])SparseBlockDevice.this.blocks.get(blockIndex);
            if (block != null) {
                int startOffset = SparseBlockDevice.this.blockIndexToOffset(blockIndex);
                int localOffset = (int)(this.offset - (long)startOffset);
                if (this.lowerStream.skip(1L) != 1L) {
                    throw new IOException();
                }
                readValue = block[localOffset];
            } else {
                readValue = this.lowerStream.read();
            }
            ++this.offset;
            return readValue;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            int readBytes;
            if (this.offset >= SparseBlockDevice.this.getCapacity()) {
                return -1;
            }
            int blockIndex = SparseBlockDevice.this.offsetToBlockIndex(this.offset);
            byte[] block = (byte[])SparseBlockDevice.this.blocks.get(blockIndex);
            if (block != null) {
                int startOffset = SparseBlockDevice.this.blockIndexToOffset(blockIndex);
                int localOffset = (int)(this.offset - (long)startOffset);
                int blockCount = SparseBlockDevice.this.blockSize - localOffset;
                readBytes = (int)this.lowerStream.skip(Math.min(blockCount, len));
                System.arraycopy(block, localOffset, b, off, readBytes);
            } else {
                readBytes = this.lowerStream.read(b, off, len);
            }
            this.offset += (long)readBytes;
            return readBytes;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.offset += n;
        }

        @Override
        public int available() throws IOException {
            return (int)(SparseBlockDevice.this.getCapacity() - this.offset);
        }
    }

    private final class SparseOutputStream
    extends OutputStream {
        private long offset;

        public SparseOutputStream(long offset) {
            this.offset = offset;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.offset >= SparseBlockDevice.this.getCapacity()) {
                throw new IOException();
            }
            int blockIndex = SparseBlockDevice.this.offsetToBlockIndex(this.offset);
            byte[] block = this.getShadowBlock(blockIndex);
            int startOffset = SparseBlockDevice.this.blockIndexToOffset(blockIndex);
            int localOffset = (int)(this.offset - (long)startOffset);
            block[localOffset] = (byte)b;
            ++this.offset;
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            if (this.offset >= SparseBlockDevice.this.getCapacity()) {
                throw new IOException();
            }
            int blockIndex = SparseBlockDevice.this.offsetToBlockIndex(this.offset);
            byte[] block = this.getShadowBlock(blockIndex);
            int startOffset = SparseBlockDevice.this.blockIndexToOffset(blockIndex);
            int localOffset = (int)(this.offset - (long)startOffset);
            int writtenBytes = Math.min(len, SparseBlockDevice.this.blockSize - localOffset);
            System.arraycopy(b, off, block, localOffset, writtenBytes);
            this.offset += (long)writtenBytes;
            if (writtenBytes < len) {
                this.write(b, off + writtenBytes, len - writtenBytes);
            }
        }

        private byte[] getShadowBlock(int blockIndex) throws IOException {
            byte[] block = (byte[])SparseBlockDevice.this.blocks.get(blockIndex);
            if (block != null) {
                return block;
            }
            block = new byte[SparseBlockDevice.this.blockSize];
            int startOffset = SparseBlockDevice.this.blockIndexToOffset(blockIndex);
            InputStream stream = SparseBlockDevice.this.lower.getInputStream(startOffset);
            int initOffset = 0;
            int initCount = SparseBlockDevice.this.blockSize;
            while (initCount > 0) {
                int read = stream.read(block, initOffset, initCount);
                if (read < 0) {
                    initCount = 0;
                    continue;
                }
                initOffset += read;
                initCount -= read;
            }
            SparseBlockDevice.this.blocks.put(blockIndex, block);
            return block;
        }
    }
}

