/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres.serializers;

import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import li.cil.ceres.api.Serializer;

public final class UUIDSerializer
implements Serializer<UUID> {
    public static final UUIDSerializer INSTANCE = new UUIDSerializer();

    @Override
    public void serialize(SerializationVisitor visitor, Class<UUID> type, Object value) throws SerializationException {
        UUID uuid = (UUID)value;
        visitor.putLong("msb", uuid.getMostSignificantBits());
        visitor.putLong("lsb", uuid.getLeastSignificantBits());
    }

    @Override
    public UUID deserialize(DeserializationVisitor visitor, Class<UUID> type, @Nullable Object value) throws SerializationException {
        if (!visitor.exists("msb") || !visitor.exists("lsb")) {
            return (UUID)value;
        }
        long msb = visitor.getLong("msb");
        long lsb = visitor.getLong("lsb");
        return new UUID(msb, lsb);
    }
}

