/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres.internal;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.BiFunction;
import li.cil.ceres.Ceres;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import li.cil.ceres.api.Serializer;
import li.cil.ceres.internal.GeneratedSerializer;
import li.cil.ceres.internal.SerializerUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import sun.misc.Unsafe;

final class CompiledSerializer {
    private static final BiFunction<Class<?>, byte[], Class<?>> DEFINE_ANONYMOUS_CLASS;
    private static final int SERIALIZER_VISITOR_INDEX = 1;
    private static final int SERIALIZER_VALUE_INDEX = 3;
    private static final int SERIALIZER_FIELD_VALUE_INDEX = 4;
    private static final int DESERIALIZER_VISITOR_INDEX = 1;
    private static final int DESERIALIZER_VALUE_INDEX = 3;

    CompiledSerializer() {
    }

    public static <T> Serializer<T> generateSerializer(final Class<T> type) throws SerializationException {
        if (type.isInterface()) {
            throw new SerializationException(String.format("Cannot generate serializer for interface [%s].", type));
        }
        ArrayList<Field> fields = SerializerUtils.collectSerializableFields(type);
        String className = Type.getInternalName(type) + "$" + Type.getInternalName(Serializer.class).replace('/', '_');
        SignatureWriter classSignature = new SignatureWriter();
        SignatureVisitor serializer = classSignature.visitInterface();
        serializer.visitClassType(Type.getInternalName(Serializer.class));
        SignatureVisitor serializerType = serializer.visitTypeArgument('=');
        serializerType.visitClassType(Type.getInternalName(type));
        serializerType.visitEnd();
        serializer.visitEnd();
        classSignature.visitEnd();
        ClassWriter cw = new ClassWriter(2){

            protected ClassLoader getClassLoader() {
                return type.getClassLoader();
            }
        };
        cw.visit(52, 17, className, classSignature.toString(), Type.getInternalName(Object.class), new String[]{Type.getInternalName(Serializer.class), Type.getInternalName(GeneratedSerializer.class)});
        MethodVisitor init = cw.visitMethod(1, "<init>", "()V", null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        init.visitInsn(177);
        init.visitMaxs(-1, -1);
        init.visitEnd();
        MethodVisitor hasSerializedFields = cw.visitMethod(17, "hasSerializedFields", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), null, null);
        hasSerializedFields.visitCode();
        if (fields.isEmpty()) {
            hasSerializedFields.visitLdcInsn((Object)false);
        } else {
            hasSerializedFields.visitLdcInsn((Object)true);
        }
        hasSerializedFields.visitInsn(172);
        hasSerializedFields.visitMaxs(-1, -1);
        hasSerializedFields.visitEnd();
        MethodVisitor serialize = cw.visitMethod(17, "serialize", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(SerializationVisitor.class), Type.getType(Class.class), Type.getType(Object.class)}), null, new String[]{Type.getInternalName(SerializationException.class)});
        serialize.visitCode();
        CompiledSerializer.generateSerializeMethod(serialize, type, fields);
        serialize.visitMaxs(-1, -1);
        serialize.visitEnd();
        MethodVisitor deserialize = cw.visitMethod(17, "deserialize", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(DeserializationVisitor.class), Type.getType(Class.class), Type.getType(Object.class)}), null, new String[]{Type.getInternalName(SerializationException.class)});
        deserialize.visitCode();
        CompiledSerializer.generateDeserializeMethod(deserialize, type, fields);
        deserialize.visitMaxs(-1, -1);
        deserialize.visitEnd();
        cw.visitEnd();
        try {
            Class<?> serializerClass = DEFINE_ANONYMOUS_CLASS.apply(type, cw.toByteArray());
            return (Serializer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new SerializationException(String.format("Failed generating serializer for type [%s]", type), e);
        }
    }

    private static <T> void generateSerializeMethod(MethodVisitor mv, Class<T> type, ArrayList<Field> fields) {
        int fieldValueCount = 0;
        mv.visitVarInsn(25, 3);
        mv.visitTypeInsn(192, Type.getInternalName(type));
        mv.visitVarInsn(58, 3);
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            if (fieldType == Boolean.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putBoolean");
                continue;
            }
            if (fieldType == Byte.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putByte");
                continue;
            }
            if (fieldType == Character.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putChar");
                continue;
            }
            if (fieldType == Short.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putShort");
                continue;
            }
            if (fieldType == Integer.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putInt");
                continue;
            }
            if (fieldType == Long.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putLong");
                continue;
            }
            if (fieldType == Float.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putFloat");
                continue;
            }
            if (fieldType == Double.TYPE) {
                CompiledSerializer.generateSerializePrimitiveCall(mv, type, field, fieldType, "putDouble");
                continue;
            }
            Label fieldValueValidLabel = new Label();
            Label nothrowLabel = new Label();
            Label throwDedupLabel = new Label();
            Label throwLabel = new Label();
            Label endifLabel = new Label();
            mv.visitLocalVariable("fieldValue" + fieldValueCount++, Type.getDescriptor(fieldType), null, fieldValueValidLabel, endifLabel, 4);
            mv.visitVarInsn(25, 3);
            mv.visitFieldInsn(180, Type.getInternalName(type), field.getName(), Type.getDescriptor(fieldType));
            mv.visitInsn(89);
            mv.visitVarInsn(58, 4);
            mv.visitLabel(fieldValueValidLabel);
            mv.visitJumpInsn(198, nothrowLabel);
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()Ljava/lang/Class;", false);
            mv.visitLdcInsn((Object)Type.getType(fieldType));
            mv.visitJumpInsn(165, nothrowLabel);
            mv.visitLdcInsn((Object)Type.getType(fieldType));
            mv.visitLdcInsn((Object)false);
            mv.visitMethodInsn(184, Type.getInternalName(Ceres.class), "getSerializer", "(Ljava/lang/Class;Z)Lli/cil/ceres/api/Serializer;", false);
            mv.visitInsn(89);
            mv.visitJumpInsn(198, throwDedupLabel);
            mv.visitTypeInsn(193, Type.getInternalName(GeneratedSerializer.class));
            mv.visitJumpInsn(153, nothrowLabel);
            mv.visitJumpInsn(167, throwLabel);
            mv.visitLabel(throwDedupLabel);
            mv.visitInsn(87);
            mv.visitLabel(throwLabel);
            mv.visitTypeInsn(187, Type.getInternalName(SerializationException.class));
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Value type [%s] does not match field type in field [%s.%s] and no explicit serializer has been registered for field type [%s]. Polymorphism is not supported when using generated serializers.");
            mv.visitLdcInsn((Object)4);
            mv.visitTypeInsn(189, Type.getInternalName(Object.class));
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)0);
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()Ljava/lang/Class;", false);
            mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getName", "()Ljava/lang/String;", false);
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)1);
            mv.visitLdcInsn((Object)type.getName());
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)2);
            mv.visitLdcInsn((Object)field.getName());
            mv.visitInsn(83);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)3);
            mv.visitLdcInsn((Object)fieldType.getName());
            mv.visitInsn(83);
            mv.visitMethodInsn(184, Type.getInternalName(String.class), "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            mv.visitMethodInsn(183, Type.getInternalName(SerializationException.class), "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            mv.visitLabel(nothrowLabel);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)field.getName());
            mv.visitLdcInsn((Object)Type.getType(fieldType));
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(185, Type.getInternalName(SerializationVisitor.class), "putObject", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;)V", true);
            mv.visitLabel(endifLabel);
        }
        Class<T> parentType = type.getSuperclass();
        if (parentType != null && parentType != Object.class) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)"<super>");
            mv.visitLdcInsn((Object)Type.getType(type));
            mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getSuperclass", "()Ljava/lang/Class;", false);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, Type.getInternalName(SerializationVisitor.class), "putObject", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;)V", true);
        }
        mv.visitInsn(177);
    }

    private static <T> void generateDeserializeMethod(MethodVisitor mv, Class<T> type, ArrayList<Field> fields) {
        Label nonnullLabel = new Label();
        mv.visitVarInsn(25, 3);
        mv.visitJumpInsn(199, nonnullLabel);
        if (Modifier.isAbstract(type.getModifiers())) {
            mv.visitTypeInsn(187, Type.getInternalName(SerializationException.class));
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)String.format("Cannot create new instance of abstract type [%s].", type));
            mv.visitMethodInsn(183, Type.getInternalName(SerializationException.class), "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
        } else {
            boolean hasDefaultConstructor = false;
            try {
                type.getDeclaredConstructor(new Class[0]);
                hasDefaultConstructor = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (!hasDefaultConstructor) {
                mv.visitTypeInsn(187, Type.getInternalName(SerializationException.class));
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)String.format("Cannot create new instance of type without a default constructor [%s].", type));
                mv.visitMethodInsn(183, Type.getInternalName(SerializationException.class), "<init>", "(Ljava/lang/String;)V", false);
                mv.visitInsn(191);
            } else {
                mv.visitTypeInsn(187, Type.getInternalName(type));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, Type.getInternalName(type), "<init>", "()V", false);
                mv.visitVarInsn(58, 3);
            }
        }
        mv.visitLabel(nonnullLabel);
        mv.visitVarInsn(25, 3);
        mv.visitTypeInsn(192, Type.getInternalName(type));
        mv.visitVarInsn(58, 3);
        for (Field field : fields) {
            Label endifLabel = new Label();
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)field.getName());
            mv.visitMethodInsn(185, Type.getInternalName(DeserializationVisitor.class), "exists", "(Ljava/lang/String;)Z", true);
            mv.visitJumpInsn(153, endifLabel);
            mv.visitVarInsn(25, 3);
            Class<?> fieldType = field.getType();
            if (fieldType == Boolean.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getBoolean");
            } else if (fieldType == Byte.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getByte");
            } else if (fieldType == Character.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getChar");
            } else if (fieldType == Short.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getShort");
            } else if (fieldType == Integer.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getInt");
            } else if (fieldType == Long.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getLong");
            } else if (fieldType == Float.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getFloat");
            } else if (fieldType == Double.TYPE) {
                CompiledSerializer.generateDeserializePrimitiveCall(mv, type, field, fieldType, "getDouble");
            } else if (Modifier.isFinal(field.getModifiers())) {
                CompiledSerializer.generateDeserializeObjectCall(mv, type, field, fieldType);
                mv.visitInsn(88);
            } else {
                CompiledSerializer.generateDeserializeObjectCall(mv, type, field, fieldType);
                mv.visitTypeInsn(192, Type.getInternalName(fieldType));
                mv.visitFieldInsn(181, Type.getInternalName(type), field.getName(), Type.getDescriptor(fieldType));
            }
            mv.visitLabel(endifLabel);
        }
        Class<T> parentType = type.getSuperclass();
        if (parentType != null && parentType != Object.class) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)"<super>");
            mv.visitLdcInsn((Object)Type.getType(type));
            mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getSuperclass", "()Ljava/lang/Class;", false);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, Type.getInternalName(DeserializationVisitor.class), "getObject", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", true);
        }
        mv.visitVarInsn(25, 3);
        mv.visitInsn(176);
    }

    private static <T> void generateSerializePrimitiveCall(MethodVisitor mv, Class<T> type, Field field, Class<?> fieldType, String name) {
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)field.getName());
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(180, Type.getInternalName(type), field.getName(), Type.getDescriptor(fieldType));
        mv.visitMethodInsn(185, Type.getInternalName(SerializationVisitor.class), name, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(fieldType)}), true);
    }

    private static <T> void generateDeserializePrimitiveCall(MethodVisitor mv, Class<T> type, Field field, Class<?> fieldType, String name) {
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)field.getName());
        mv.visitMethodInsn(185, Type.getInternalName(DeserializationVisitor.class), name, Type.getMethodDescriptor((Type)Type.getType(fieldType), (Type[])new Type[]{Type.getType(String.class)}), true);
        mv.visitFieldInsn(181, Type.getInternalName(type), field.getName(), Type.getDescriptor(fieldType));
    }

    private static <T> void generateDeserializeObjectCall(MethodVisitor mv, Class<T> type, Field field, Class<?> fieldType) {
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)field.getName());
        mv.visitLdcInsn((Object)Type.getType(fieldType));
        mv.visitVarInsn(25, 3);
        mv.visitFieldInsn(180, Type.getInternalName(type), field.getName(), Type.getDescriptor(fieldType));
        mv.visitMethodInsn(185, Type.getInternalName(DeserializationVisitor.class), "getObject", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", true);
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            Object implLookupBase = unsafe.staticFieldBase(implLookupField);
            long implLookupOffset = unsafe.staticFieldOffset(implLookupField);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(implLookupBase, implLookupOffset);
            DEFINE_ANONYMOUS_CLASS = (parentType, bytecode) -> {
                try {
                    return lookup.in((Class<?>)parentType).defineHiddenClass((byte[])bytecode, false, MethodHandles.Lookup.ClassOption.NESTMATE).lookupClass();
                }
                catch (IllegalAccessException ignored) {
                    return null;
                }
            };
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

