/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBStructureSettings;

public class TBNoiseGeneratorSettings {
    public static final ResourceKey<NoiseGeneratorSettings> OVERWORLD = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)new ResourceLocation("terrablender", "overworld"));
    public static final ResourceKey<NoiseGeneratorSettings> LARGE_BIOMES = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)new ResourceLocation("terrablender", "large_biomes"));
    public static final ResourceKey<NoiseGeneratorSettings> AMPLIFIED = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)new ResourceLocation("terrablender", "amplified"));
    public static final ResourceKey<NoiseGeneratorSettings> NETHER = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)new ResourceLocation("terrablender", "nether"));

    public static NoiseSettings overworldNoiseSettings(boolean amplified, boolean largeBiomes) {
        return NoiseSettings.m_189199_((int)-64, (int)384, (NoiseSamplingSettings)new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), (NoiseSlider)new NoiseSlider(-0.078125, 2, 8), (NoiseSlider)new NoiseSlider(0.1171875, 3, 0), (int)1, (int)2, (boolean)false, (boolean)amplified, (boolean)largeBiomes, (TerrainShaper)TerrainProvider.m_194816_((boolean)amplified));
    }

    public static NoiseGeneratorSettings overworld(boolean amplified, boolean largeBiomes) {
        return TBNoiseGeneratorSettings.overworld(TBNoiseGeneratorSettings.overworldNoiseSettings(amplified, largeBiomes), BiomeProviderUtils.createOverworldRules());
    }

    public static NoiseGeneratorSettings overworld(NoiseSettings noiseSettings, SurfaceRules.RuleSource ruleSource) {
        return new NoiseGeneratorSettings((StructureSettings)new TBStructureSettings(true), noiseSettings, Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), ruleSource, 63, false, true, true, true, true, false);
    }

    public static NoiseSettings netherNoiseSettings() {
        return NoiseSettings.m_189199_((int)0, (int)128, (NoiseSamplingSettings)new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), (NoiseSlider)new NoiseSlider(0.9375, 3, 0), (NoiseSlider)new NoiseSlider(2.5, 4, -1), (int)1, (int)2, (boolean)false, (boolean)false, (boolean)false, (TerrainShaper)TerrainProvider.m_194815_());
    }

    public static NoiseGeneratorSettings nether() {
        return TBNoiseGeneratorSettings.nether(TBNoiseGeneratorSettings.netherNoiseSettings(), BiomeProviderUtils.createNetherRules());
    }

    public static NoiseGeneratorSettings nether(NoiseSettings noiseSettings, SurfaceRules.RuleSource ruleSource) {
        HashMap map = Maps.newHashMap((Map)StructureSettings.f_64580_);
        map.put(StructureFeature.f_67019_, new StructureFeatureConfiguration(25, 10, 34222645));
        return new NoiseGeneratorSettings(new StructureSettings(Optional.empty(), (Map)map), noiseSettings, Blocks.f_50134_.m_49966_(), Blocks.f_49991_.m_49966_(), ruleSource, 32, false, false, false, false, false, true);
    }
}

