/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.BiomeProviders;
import terrablender.api.ModifiedVanillaOverworldBuilder;
import terrablender.api.ParameterUtils;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public abstract class BiomeProvider {
    private final ResourceLocation name;
    private final int overworldWeight;
    private final int netherWeight;

    public BiomeProvider(ResourceLocation name, int overworldWeight) {
        this(name, overworldWeight, 0);
    }

    public BiomeProvider(ResourceLocation name, int overworldWeight, int netherWeight) {
        this.name = name;
        this.overworldWeight = overworldWeight;
        this.netherWeight = netherWeight;
    }

    public void addOverworldBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
    }

    public void addNetherBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
    }

    public List<TBClimate.ParameterPoint> getSpawnTargets() {
        return ImmutableList.of();
    }

    public Optional<SurfaceRules.RuleSource> getOverworldSurfaceRules() {
        return Optional.empty();
    }

    public Optional<SurfaceRules.RuleSource> getNetherSurfaceRules() {
        return Optional.empty();
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getOverworldWeight() {
        return this.overworldWeight;
    }

    public int getNetherWeight() {
        return this.netherWeight;
    }

    public final int getIndex() {
        return BiomeProviders.getIndex(this.getName());
    }

    protected final Climate.Parameter getUniquenessParameter() {
        return BiomeProviderUtils.getUniquenessParameter(this.getIndex());
    }

    protected final void addBiome(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        this.addBiome(mapper, TBClimate.parameters(temperature, humidity, continentalness, erosion, depth, weirdness, this.getUniquenessParameter(), offset), biome);
    }

    protected final void addBiome(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, ParameterUtils.Temperature temperature, ParameterUtils.Humidity humidity, ParameterUtils.Continentalness continentalness, ParameterUtils.Erosion erosion, ParameterUtils.Weirdness weirdness, ParameterUtils.Depth depth, float offset, ResourceKey<Biome> biome) {
        this.addBiome(mapper, TBClimate.parameters(temperature.parameter(), humidity.parameter(), continentalness.parameter(), erosion.parameter(), depth.parameter(), weirdness.parameter(), this.getUniquenessParameter(), offset), biome);
    }

    protected final void addBiome(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, TBClimate.ParameterPoint parameters, ResourceKey<Biome> biome) {
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)parameters, biome));
    }

    protected final void addBiomeSimilar(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, ResourceKey<Biome> similarVanillaBiome, ResourceKey<Biome> biome) {
        List points = (List)BiomeProviderUtils.getVanillaParameterPoints(similarVanillaBiome).stream().map(point -> ParameterUtils.convertParameterPoint(point, this.getUniquenessParameter())).collect(ImmutableList.toImmutableList());
        points.forEach(point -> this.addBiome(mapper, (TBClimate.ParameterPoint)point, biome));
    }

    protected final void addModifiedVanillaOverworldBiomes(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Consumer<ModifiedVanillaOverworldBuilder> onModify) {
        ModifiedVanillaOverworldBuilder builder = new ModifiedVanillaOverworldBuilder();
        onModify.accept(builder);
        builder.build(this.getUniquenessParameter()).forEach(mapper::accept);
    }
}

