/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.world;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.init.ModBlocks;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ModWorldgenRegistration {
    private static final RuleTest END_STONE_RULE_TEST = new BlockMatchTest(Blocks.f_50259_);
    private static PlacedFeature placedNetherProsperityOreFeature;
    private static PlacedFeature placedNetherInferiumOreFeature;
    private static PlacedFeature placedEndProsperityOreFeature;
    private static PlacedFeature placedEndInferiumOreFeature;

    @SubscribeEvent
    public void onBiomesLoading(BiomeLoadingEvent event) {
        Biome.BiomeCategory category = event.getCategory();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        switch (category) {
            case NETHER: {
                if (((Boolean)ModConfigs.GENERATE_NETHER_PROSPERITY.get()).booleanValue()) {
                    generation.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, placedNetherProsperityOreFeature);
                }
                if (!((Boolean)ModConfigs.GENERATE_NETHER_INFERIUM.get()).booleanValue()) break;
                generation.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, placedNetherInferiumOreFeature);
                break;
            }
            case THEEND: {
                if (((Boolean)ModConfigs.GENERATE_END_PROSPERITY.get()).booleanValue()) {
                    generation.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, placedEndProsperityOreFeature);
                }
                if (!((Boolean)ModConfigs.GENERATE_END_INFERIUM.get()).booleanValue()) break;
                generation.m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, placedEndInferiumOreFeature);
                break;
            }
        }
    }

    public static void onCommonSetup() {
        int size = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_SIZE.get();
        int minY = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_MIN_Y.get();
        int maxY = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_MAX_Y.get();
        int rate = (Integer)ModConfigs.NETHER_PROSPERITY_SPAWN_RATE.get();
        List<OreConfiguration.TargetBlockState> targets = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)((Block)ModBlocks.NETHER_PROSPERITY_ORE.get()).m_49966_()));
        ConfiguredFeature feature = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(targets, size));
        placedNetherProsperityOreFeature = feature.m_190821_(List.of(CountPlacement.m_191628_((int)rate), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()));
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "nether_prosperity_ore"), (Object)feature);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "nether_prosperity_ore"), (Object)placedNetherProsperityOreFeature);
        size = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_SIZE.get();
        minY = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_MIN_Y.get();
        maxY = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_MAX_Y.get();
        rate = (Integer)ModConfigs.NETHER_INFERIUM_SPAWN_RATE.get();
        targets = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)((Block)ModBlocks.NETHER_INFERIUM_ORE.get()).m_49966_()));
        feature = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(targets, size));
        placedNetherInferiumOreFeature = feature.m_190821_(List.of(CountPlacement.m_191628_((int)rate), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()));
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "nether_inferium_ore"), (Object)feature);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "nether_inferium_ore"), (Object)placedNetherInferiumOreFeature);
        size = (Integer)ModConfigs.END_PROSPERITY_SPAWN_SIZE.get();
        minY = (Integer)ModConfigs.END_PROSPERITY_SPAWN_MIN_Y.get();
        maxY = (Integer)ModConfigs.END_PROSPERITY_SPAWN_MAX_Y.get();
        rate = (Integer)ModConfigs.END_PROSPERITY_SPAWN_RATE.get();
        targets = List.of(OreConfiguration.m_161021_((RuleTest)END_STONE_RULE_TEST, (BlockState)((Block)ModBlocks.END_PROSPERITY_ORE.get()).m_49966_()));
        feature = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(targets, size));
        placedEndProsperityOreFeature = feature.m_190821_(List.of(CountPlacement.m_191628_((int)rate), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()));
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "end_prosperity_ore"), (Object)feature);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "end_prosperity_ore"), (Object)placedEndProsperityOreFeature);
        size = (Integer)ModConfigs.END_INFERIUM_SPAWN_SIZE.get();
        minY = (Integer)ModConfigs.END_INFERIUM_SPAWN_MIN_Y.get();
        maxY = (Integer)ModConfigs.END_INFERIUM_SPAWN_MAX_Y.get();
        rate = (Integer)ModConfigs.END_INFERIUM_SPAWN_RATE.get();
        targets = List.of(OreConfiguration.m_161021_((RuleTest)END_STONE_RULE_TEST, (BlockState)((Block)ModBlocks.END_INFERIUM_ORE.get()).m_49966_()));
        feature = Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(targets, size));
        placedEndInferiumOreFeature = feature.m_190821_(List.of(CountPlacement.m_191628_((int)rate), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()));
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "end_inferium_ore"), (Object)feature);
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("mysticalagradditions", "end_inferium_ore"), (Object)placedEndInferiumOreFeature);
    }
}

