/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import malte0811.modelsplitter.math.EpsilonMath;
import malte0811.modelsplitter.math.Plane;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Group;
import malte0811.modelsplitter.model.MaterialLibrary;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.UVCoords;
import malte0811.modelsplitter.model.Vertex;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class OBJModel<Texture> {
    public static final String DEFAULT_GROUP = "default";
    private final Map<String, Group<Texture>> faces;
    private final List<Polygon<Texture>> allFaces;

    public OBJModel(Map<String, Group<Texture>> faces) {
        this.faces = ImmutableMap.copyOf(faces);
        ImmutableList.Builder faceListBuilder = ImmutableList.builder();
        for (Group<Texture> group : faces.values()) {
            Preconditions.checkState((!group.getFaces().isEmpty() ? 1 : 0) != 0);
            faceListBuilder.addAll(group.getFaces());
        }
        this.allFaces = faceListBuilder.build();
    }

    public OBJModel(List<Polygon<Texture>> allFaces) {
        this(Map.of("", new Group<Texture>(allFaces)));
    }

    private OBJModel(Stream<Map.Entry<String, List<Polygon<Texture>>>> faces) {
        this(faces.map(e -> Pair.of((Object)((String)e.getKey()), new Group((List)e.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    public static OBJModel<MaterialLibrary.OBJMaterial> readFromStream(InputStream source, Function<String, InputStream> getMTLInput) {
        record ParserFace(List<ParserVertex> vertices, MaterialLibrary.OBJMaterial material) {
            private final List<ParserVertex> vertices;

            ParserFace {
                record ParserVertex(int pos, int normal, int uv) {
                }
            }

            public List<ParserVertex> vertices() {
                return this.vertices;
            }
        }
        ArrayList points = new ArrayList();
        ArrayList normals = new ArrayList();
        ArrayList uvs = new ArrayList();
        HashMap parserGroups = new HashMap();
        MutableObject currentGroup = new MutableObject((Object)DEFAULT_GROUP);
        MutableObject currentMTL = new MutableObject(null);
        MutableObject currentMat = new MutableObject(null);
        OBJModel.getRelevantLines(source).forEach(p -> {
            StringTokenizer tokenizer = (StringTokenizer)p.getValue();
            switch ((String)p.getKey()) {
                case "mtllib": {
                    InputStream mtlInput = (InputStream)getMTLInput.apply(tokenizer.nextToken());
                    MaterialLibrary mtl = MaterialLibrary.parse(OBJModel.getRelevantLines(mtlInput));
                    currentMTL.setValue((Object)mtl);
                    break;
                }
                case "v": {
                    points.add(new Vec3d(OBJModel.readTokens(tokenizer, 3)));
                    break;
                }
                case "vn": {
                    normals.add(new Vec3d(OBJModel.readTokens(tokenizer, 3)));
                    break;
                }
                case "vt": {
                    uvs.add(new UVCoords(OBJModel.readTokens(tokenizer, 2)));
                    break;
                }
                case "f": {
                    ArrayList<ParserVertex> vertices = new ArrayList<ParserVertex>();
                    while (tokenizer.hasMoreTokens()) {
                        String vertex = tokenizer.nextToken();
                        String[] parts = vertex.split("/");
                        int posId = Integer.parseInt(parts[0]) - 1;
                        int vt = !parts[1].isEmpty() ? Integer.parseInt(parts[1]) - 1 : -1;
                        int vn = parts.length > 2 ? Integer.parseInt(parts[2]) - 1 : -1;
                        vertices.add(new ParserVertex(posId, vn, vt));
                    }
                    parserGroups.computeIfAbsent((String)currentGroup.getValue(), s -> new ArrayList()).add(new ParserFace(vertices, (MaterialLibrary.OBJMaterial)currentMat.getValue()));
                    break;
                }
                case "o": {
                    currentGroup.setValue((Object)tokenizer.nextToken());
                    break;
                }
                case "s": {
                    break;
                }
                case "usemtl": {
                    Map<String, MaterialLibrary.OBJMaterial> materialMap = ((MaterialLibrary)currentMTL.getValue()).materials();
                    String materialName = tokenizer.nextToken();
                    MaterialLibrary.OBJMaterial newMaterial = materialMap.get(materialName);
                    currentMat.setValue((Object)Objects.requireNonNull(newMaterial, "No material " + materialName));
                    break;
                }
                default: {
                    System.out.println("Ignoring line with token " + (String)p.getKey());
                }
            }
        });
        HashMap groups = new HashMap();
        for (Map.Entry parserEntry : parserGroups.entrySet()) {
            ArrayList<Polygon<MaterialLibrary.OBJMaterial>> group = new ArrayList<Polygon<MaterialLibrary.OBJMaterial>>(((List)parserEntry.getValue()).size());
            for (ParserFace parserPoly : (List)parserEntry.getValue()) {
                ArrayList<Vertex> vertices = new ArrayList<Vertex>(parserPoly.vertices().size());
                for (ParserVertex point : parserPoly.vertices()) {
                    vertices.add(new Vertex((Vec3d)points.get(point.pos), point.normal >= 0 ? (Vec3d)normals.get(point.normal) : Vec3d.ZERO, point.uv >= 0 ? (UVCoords)uvs.get(point.uv) : UVCoords.ZERO));
                }
                group.add(new Polygon<MaterialLibrary.OBJMaterial>(vertices, parserPoly.material()));
            }
            groups.put((String)parserEntry.getKey(), group);
        }
        return new OBJModel<MaterialLibrary.OBJMaterial>(groups.entrySet().stream());
    }

    private static Stream<Pair<String, StringTokenizer>> getRelevantLines(InputStream in) {
        return new BufferedReader(new InputStreamReader(in)).lines().filter(l -> !l.trim().isEmpty() && l.charAt(0) != '#').map(s -> {
            StringTokenizer tokenizer = new StringTokenizer((String)s);
            return Pair.of((Object)tokenizer.nextToken(), (Object)tokenizer);
        });
    }

    public static <Texture> OBJModel<Texture> union(@Nullable OBJModel<Texture> a, @Nullable OBJModel<Texture> b) {
        Stream<Map.Entry> unionGroups = Stream.empty();
        if (a != null) {
            unionGroups = Stream.concat(unionGroups, a.getFacesByGroup().entrySet().stream());
        }
        if (b != null) {
            unionGroups = Stream.concat(unionGroups, b.getFacesByGroup().entrySet().stream());
        }
        return new OBJModel<Texture>(unionGroups.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Group::merge)));
    }

    private static double[] readTokens(StringTokenizer tokenizer, int tokens) {
        double[] data = new double[tokens];
        for (int i = 0; i < tokens; ++i) {
            data[i] = Double.parseDouble(tokenizer.nextToken());
        }
        return data;
    }

    public Map<EpsilonMath.Sign, OBJModel<Texture>> split(Plane splitPlane) {
        EnumMap resultFaces = new EnumMap(EpsilonMath.Sign.class);
        for (Map.Entry group : this.faces.entrySet()) {
            group.getValue().split(splitPlane).forEach(p -> resultFaces.computeIfAbsent((EpsilonMath.Sign)((Object)((Object)p.getKey())), s -> new HashMap()).merge((String)group.getKey(), (Group)p.getValue(), Group::merge));
        }
        return resultFaces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OBJModel((Map)e.getValue())));
    }

    public void write(OutputStream outRaw) {
        PrintStream out = new PrintStream(outRaw);
        Object2IntOpenHashMap points = new Object2IntOpenHashMap();
        Object2IntOpenHashMap uvs = new Object2IntOpenHashMap();
        for (Map.Entry<String, Group<Texture>> group : this.faces.entrySet()) {
            out.println("o " + group.getKey());
            for (Polygon<Texture> f : group.getValue().getFaces()) {
                StringJoiner line = new StringJoiner(" ", "f ", "");
                for (Vertex v : f.getPoints()) {
                    int vIndex = points.computeIfAbsent((Object)v.position(), arg_0 -> OBJModel.lambda$write$8(out, (Object2IntMap)points, arg_0)) + 1;
                    int uvIndex = uvs.computeIfAbsent((Object)v.uv(), arg_0 -> OBJModel.lambda$write$9(out, (Object2IntMap)uvs, arg_0)) + 1;
                    line.add(vIndex + "/" + uvIndex);
                }
                out.println(line);
            }
        }
    }

    public boolean isEmpty() {
        return this.faces.isEmpty();
    }

    public List<Polygon<Texture>> getFaces() {
        return this.allFaces;
    }

    public Map<String, Group<Texture>> getFacesByGroup() {
        return this.faces;
    }

    private OBJModel<Texture> mapGroups(UnaryOperator<Group<Texture>> map) {
        HashMap<String, Group<Texture>> translatedGroups = new HashMap<String, Group<Texture>>();
        for (Map.Entry<String, Group<Texture>> p : this.faces.entrySet()) {
            translatedGroups.put(p.getKey(), (Group)map.apply(p.getValue()));
        }
        return new OBJModel<Texture>(translatedGroups);
    }

    public OBJModel<Texture> translate(int axis, double amount) {
        return this.mapGroups(g -> g.translate(axis, amount));
    }

    public OBJModel<Texture> translate(Vec3d offset) {
        return this.mapGroups(g -> g.translate(offset));
    }

    public OBJModel<Texture> quadify() {
        return this.mapGroups(Group::quadify);
    }

    public OBJModel<Texture> recomputeZeroNormals() {
        return this.mapGroups(Group::recomputeZeroNormals);
    }

    private static /* synthetic */ int lambda$write$9(PrintStream out, Object2IntMap uvs, UVCoords uv) {
        out.printf("vt %.6f %.6f\n", uv.u(), uv.v());
        return uvs.size();
    }

    private static /* synthetic */ int lambda$write$8(PrintStream out, Object2IntMap points, Vec3d pos) {
        out.printf("v %.4f %.4f %.4f\n", pos.get(0), pos.get(1), pos.get(2));
        return points.size();
    }
}

