/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import malte0811.modelsplitter.math.EpsilonMath;
import malte0811.modelsplitter.math.Plane;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Polygon;
import org.apache.commons.lang3.tuple.Pair;

public record Group<Texture>(List<Polygon<Texture>> faces) {
    public Group(List<Polygon<Texture>> faces) {
        this.faces = ImmutableList.copyOf(faces);
    }

    public List<Polygon<Texture>> getFaces() {
        return this.faces;
    }

    public Stream<Pair<EpsilonMath.Sign, Group<Texture>>> split(Plane p) {
        EnumMap<EpsilonMath.Sign, List> splitFaces = new EnumMap<EpsilonMath.Sign, List>(EpsilonMath.Sign.class);
        for (Polygon<Texture> f : this.getFaces()) {
            Map<EpsilonMath.Sign, Polygon<Texture>> splitResult = f.splitAlong(p);
            for (Map.Entry<EpsilonMath.Sign, Polygon<Texture>> e2 : splitResult.entrySet()) {
                splitFaces.computeIfAbsent(e2.getKey(), s -> new ArrayList()).add(e2.getValue());
            }
        }
        return splitFaces.entrySet().stream().map(e -> Pair.of((Object)((Object)((EpsilonMath.Sign)((Object)((Object)e.getKey())))), new Group((List)e.getValue())));
    }

    public Group<Texture> merge(Group<Texture> other) {
        return new Group<Texture>(ImmutableList.builder().addAll(this.getFaces()).addAll(other.getFaces()).build());
    }

    private Group<Texture> mapFaces(UnaryOperator<Polygon<Texture>> map) {
        return this.flatmapFaces(map.andThen(Stream::of));
    }

    private Group<Texture> flatmapFaces(Function<Polygon<Texture>, Stream<Polygon<Texture>>> map) {
        return new Group<Texture>((List)this.faces.stream().flatMap(map).collect(ImmutableList.toImmutableList()));
    }

    public Group<Texture> translate(int axis, double amount) {
        return this.mapFaces(p -> p.translate(axis, amount));
    }

    public Group<Texture> translate(Vec3d offset) {
        return this.mapFaces(p -> p.translate(offset));
    }

    public Group<Texture> quadify() {
        return this.flatmapFaces(p -> p.quadify().stream());
    }

    public Group<Texture> recomputeZeroNormals() {
        return this.mapFaces(Polygon::recomputeZeroNormals);
    }
}

