/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PositionedItemStack {
    public Object stack;
    public int x;
    public int y;
    private List<ItemStack> displayList;

    public PositionedItemStack(Object stack, int x, int y) {
        this.stack = stack;
        this.x = x;
        this.y = y;
    }

    public List<ItemStack> getDisplayList() {
        if (this.displayList == null) {
            this.init();
        }
        return this.displayList;
    }

    private void init() {
        this.displayList = new ArrayList<ItemStack>();
        if (this.stack instanceof ItemStack) {
            this.displayList.add((ItemStack)this.stack);
        } else if (this.stack instanceof ItemStack[]) {
            Collections.addAll(this.displayList, (ItemStack[])this.stack);
        } else if (this.stack instanceof Ingredient) {
            this.displayList.addAll(Arrays.asList(((Ingredient)this.stack).m_43908_()));
        } else if (this.stack instanceof List && !((List)this.stack).isEmpty()) {
            this.displayList.addAll((List)this.stack);
        } else if (this.stack instanceof Tag) {
            ((Tag)this.stack).m_6497_().stream().map(o -> ((ItemLike)o).m_5456_()).map(ItemStack::new).forEach(this.displayList::add);
        } else {
            throw new RuntimeException("Unexpected stack object: " + this.stack);
        }
    }

    public ItemStack getStack() {
        if (this.displayList == null) {
            this.init();
        }
        if (this.displayList.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int perm = (int)(System.currentTimeMillis() / 1000L % (long)this.displayList.size());
        return this.displayList.get(perm);
    }
}

