/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.utils.PrivateAccess;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ManualElementCrafting
extends SpecialManualElements {
    private Object[] recipeRows;
    private List<PositionedItemStack[]>[] recipeLayout;
    private int[] recipePage;
    private int[] heightPixels;

    public ManualElementCrafting(ManualInstance manual, Object ... stacks) {
        super(manual);
        this.recipeRows = stacks;
        this.recipePage = new int[stacks.length];
        this.heightPixels = new int[stacks.length];
        this.recipeLayout = new List[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            this.recipeLayout[i] = new ArrayList<PositionedItemStack[]>();
        }
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.providedItems.clear();
        for (int iStack = 0; iStack < this.recipeRows.length; ++iStack) {
            this.recipeLayout[iStack].clear();
            Object stack = this.recipeRows[iStack];
            if (stack instanceof PositionedItemStack[]) {
                this.addFixedRecipe(iStack, (PositionedItemStack[])stack);
                continue;
            }
            if (stack instanceof Object[]) {
                for (Object subStack : (Object[])stack) {
                    if (subStack instanceof PositionedItemStack[]) {
                        this.addFixedRecipe(iStack, (PositionedItemStack[])subStack);
                        continue;
                    }
                    this.checkAllRecipesFor(subStack, iStack);
                }
                continue;
            }
            this.checkAllRecipesFor(stack, iStack);
        }
    }

    private void checkAllRecipesFor(Object stack, int recipeIndex) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        Map recipes = PrivateAccess.getRecipes(recipeManager, RecipeType.f_44107_);
        if (stack instanceof ResourceLocation) {
            Recipe recipe = recipes.get(stack);
            if (recipe != null) {
                this.checkRecipe(recipe, stack, recipeIndex);
            }
        } else {
            for (Recipe recipe : recipes.values()) {
                this.checkRecipe(recipe, stack, recipeIndex);
            }
        }
    }

    private void checkRecipe(Recipe<CraftingContainer> rec, Object stack, int recipeIndex) {
        boolean matches;
        boolean bl = matches = !rec.m_8043_().m_41619_() && ManualUtils.stackMatchesObject(rec.m_8043_(), stack);
        if (!matches && stack instanceof ResourceLocation && stack.equals(rec.m_6423_())) {
            matches = true;
        }
        if (matches) {
            int recipeHeight;
            int recipeWidth;
            NonNullList ingredientsPre = rec.m_7527_();
            if (rec instanceof IShapedRecipe) {
                recipeWidth = ((IShapedRecipe)rec).getRecipeWidth();
                recipeHeight = ((IShapedRecipe)rec).getRecipeHeight();
            } else {
                recipeWidth = Mth.m_14045_((int)ingredientsPre.size(), (int)1, (int)3);
                recipeHeight = (ingredientsPre.size() - 1) / 3 + 1;
            }
            int yOffset = (this.heightPixels[recipeIndex] - 18 * recipeHeight) / 2;
            if (yOffset < 0) {
                yOffset = 0;
            }
            PositionedItemStack[] pIngredients = new PositionedItemStack[ingredientsPre.size() + 1];
            int xBase = (120 - (recipeWidth + 2) * 18) / 2;
            for (int heightPos = 0; heightPos < recipeHeight; ++heightPos) {
                for (int widthPos = 0; widthPos < recipeWidth; ++widthPos) {
                    int index = heightPos * recipeWidth + widthPos;
                    if (index >= ingredientsPre.size()) continue;
                    pIngredients[index] = new PositionedItemStack(ingredientsPre.get(index), xBase + widthPos * 18, heightPos * 18 + yOffset);
                }
            }
            pIngredients[pIngredients.length - 1] = new PositionedItemStack(rec.m_8043_(), xBase + recipeWidth * 18 + 18, recipeHeight * 9 - 8 + yOffset);
            if (this.heightPixels[recipeIndex] < recipeHeight * 18) {
                this.heightPixels[recipeIndex] = recipeHeight * 18;
                for (int prevId = 0; prevId <= recipeIndex; ++prevId) {
                    for (PositionedItemStack[] oldStacks : this.recipeLayout[prevId]) {
                        for (PositionedItemStack oldStack : oldStacks) {
                            oldStack.y += yOffset;
                        }
                    }
                }
            }
            this.recipeLayout[recipeIndex].add(pIngredients);
            this.addProvidedItem(rec.m_8043_());
        }
    }

    private void addFixedRecipe(int index, PositionedItemStack[] recipe) {
        int height = 0;
        for (PositionedItemStack stack : recipe) {
            if (stack.y <= height) continue;
            height = stack.y;
        }
        if (this.heightPixels[index] < (height += 18)) {
            int offset = (height - this.heightPixels[index]) / 2;
            this.heightPixels[index] = height;
            for (int prevId = 0; prevId <= index; ++prevId) {
                for (PositionedItemStack[] oldStacks : this.recipeLayout[prevId]) {
                    for (PositionedItemStack oldStack : oldStacks) {
                        oldStack.y += offset;
                    }
                }
            }
        } else {
            int offset = (this.heightPixels[index] - height) / 2;
            for (PositionedItemStack stack : recipe) {
                stack.y += offset;
            }
        }
        this.recipeLayout[index].add(recipe);
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        int recipeYOffset = 0;
        for (int i = 0; i < this.recipeRows.length; ++i) {
            if (this.recipeLayout[i].size() > 1) {
                int iFinal = i;
                pageButtons.add(new GuiButtonManualNavigation(gui, x - 2, y + recipeYOffset + this.heightPixels[i] / 2 - 5, 8, 10, 0, btn -> {
                    int n = iFinal;
                    this.recipePage[n] = this.recipePage[n] - 1;
                    if (this.recipePage[iFinal] < 0) {
                        this.recipePage[iFinal] = this.recipeLayout[iFinal].size() - 1;
                    }
                }));
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 122 - 16, y + recipeYOffset + this.heightPixels[i] / 2 - 5, 8, 10, 1, btn -> {
                    int n = iFinal;
                    this.recipePage[n] = this.recipePage[n] + 1;
                    if (this.recipePage[iFinal] >= this.recipeLayout[iFinal].size()) {
                        this.recipePage[iFinal] = 0;
                    }
                }));
            }
            if (this.recipeLayout[i].size() <= 0) continue;
            recipeYOffset += this.heightPixels[i] + 8;
        }
        super.onOpened(gui, x, y + recipeYOffset - 2, pageButtons);
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        List<PositionedItemStack[]> rList;
        int i;
        int totalYOff = 0;
        this.highlighted = ItemStack.f_41583_;
        for (i = 0; i < this.recipeRows.length; ++i) {
            rList = this.recipeLayout[i];
            if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= rList.size()) continue;
            int maxX = 0;
            PositionedItemStack[] positionedItemStackArray = rList.get(this.recipePage[i]);
            int n = positionedItemStackArray.length;
            for (int j = 0; j < n; ++j) {
                PositionedItemStack pstack = positionedItemStackArray[j];
                if (pstack == null) continue;
                if (pstack.x > maxX) {
                    maxX = pstack.x;
                }
                GuiComponent.m_93172_((PoseStack)transform, (int)(x + pstack.x), (int)(y + totalYOff + pstack.y), (int)(x + pstack.x + 16), (int)(y + totalYOff + pstack.y + 16), (int)0x33666666);
            }
            ManualUtils.drawTexturedRect(transform, this.manual.texture, x + maxX - 17, y + totalYOff + this.heightPixels[i] / 2 - 5, 16, 10, 0.0f, 0.0625f, 0.8828125f, 0.921875f);
            totalYOff += this.heightPixels[i] + 8;
        }
        totalYOff = 0;
        for (i = 0; i < this.recipeLayout.length; ++i) {
            rList = this.recipeLayout[i];
            if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= rList.size()) continue;
            for (PositionedItemStack pstack : rList.get(this.recipePage[i])) {
                if (pstack == null || pstack.getStack().m_41619_()) continue;
                ManualUtils.renderItemStack(transform, pstack.getStack(), x + pstack.x, y + totalYOff + pstack.y, true);
                if (mx < x + pstack.x || mx >= x + pstack.x + 16 || my < y + totalYOff + pstack.y || my >= y + totalYOff + pstack.y + 16) continue;
                this.highlighted = pstack.getStack();
            }
            totalYOff += this.heightPixels[i] + 8;
        }
        this.renderHighlightedTooltip(transform, gui, mx, my);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        for (Object stack : this.recipeRows) {
            if (stack instanceof Object[]) {
                for (Object subStack : (Object[])stack) {
                    if (!(subStack instanceof ItemStack) || !ManualUtils.listStack(searchTag, (ItemStack)subStack)) continue;
                    return true;
                }
                continue;
            }
            if (!(stack instanceof ItemStack) || !ManualUtils.listStack(searchTag, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPixelsTaken() {
        int yOff = 0;
        for (int heightPixel : this.heightPixels) {
            yOff += heightPixel + 8;
        }
        return yOff;
    }
}

